/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion;

import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class ProjectConversionTestUtil {
    private ProjectConversionTestUtil() {
    }

    public static void assertNoConversionNeeded(String projectPath) {
        MyConversionListener listener = new MyConversionListener();
        ConversionResult result = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)listener);
        Assert.assertTrue((boolean)result.conversionNotNeeded());
        Assert.assertFalse((boolean)listener.isConversionNeeded());
        Assert.assertFalse((boolean)listener.isConverted());
    }

    public static void convert(String projectPath) {
        MyConversionListener listener = new MyConversionListener();
        ConversionResult result = ConversionService.getInstance().convertSilently(projectPath, (ConversionListener)listener);
        Assert.assertFalse((boolean)result.conversionNotNeeded());
        Assert.assertFalse((boolean)result.openingIsCanceled());
        Assert.assertTrue((boolean)listener.isConversionNeeded());
        Assert.assertTrue((boolean)listener.isConverted());
    }

    public static class MyConversionListener
    implements ConversionListener {
        private boolean myConversionNeeded;
        private boolean myConverted;

        public void conversionNeeded() {
            this.myConversionNeeded = true;
        }

        public void successfullyConverted(@NotNull File backupDir) {
            this.myConverted = true;
        }

        public void error(@NotNull String message) {
            Assert.fail((String)message);
        }

        public void cannotWriteToFiles(@NotNull List<? extends File> readonlyFiles) {
        }

        public boolean isConversionNeeded() {
            return this.myConversionNeeded;
        }

        public boolean isConverted() {
            return this.myConverted;
        }
    }
}

