/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.coverage.actions.HideCoverageInfoAction;
import com.intellij.coverage.actions.ShowCoveringTestsAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageLineMarkerRenderer
implements ActiveGutterRenderer,
LineMarkerRendererWithErrorStripe {
    private static final int THICKNESS = 8;
    private final TextAttributesKey myKey;
    private final String myClassName;
    private final TreeMap<Integer, LineData> myLines;
    private final boolean myCoverageByTestApplicable;
    private final Function<? super Integer, Integer> myNewToOldConverter;
    private final Function<? super Integer, Integer> myOldToNewConverter;
    private final CoverageSuitesBundle myCoverageSuite;
    private final boolean mySubCoverageActive;
    private final int myLineNumber;

    protected CoverageLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, CoverageSuitesBundle coverageSuite, boolean subCoverageActive) {
        this.myKey = CoverageLineMarkerRenderer.getAttributesKey(lineNumber, lines);
        this.myLineNumber = lineNumber;
        this.myClassName = className;
        this.myLines = lines;
        this.myCoverageByTestApplicable = coverageByTestApplicable;
        this.myNewToOldConverter = newToOldConverter;
        this.myOldToNewConverter = oldToNewConverter;
        this.myCoverageSuite = coverageSuite;
        this.mySubCoverageActive = subCoverageActive;
    }

    @Deprecated
    protected CoverageLineMarkerRenderer(TextAttributesKey key, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, CoverageSuitesBundle coverageSuite, boolean subCoverageActive) {
        this.myKey = key;
        this.myClassName = className;
        this.myLines = lines;
        this.myCoverageByTestApplicable = coverageByTestApplicable;
        this.myNewToOldConverter = newToOldConverter;
        this.myOldToNewConverter = oldToNewConverter;
        this.myCoverageSuite = coverageSuite;
        this.mySubCoverageActive = subCoverageActive;
        this.myLineNumber = -1;
    }

    private int getCurrentLineNumber(@NotNull Editor editor, Point mousePosition) {
        if (this.myLineNumber > -1) {
            return this.myLineNumber;
        }
        return editor.xyToLogicalPosition((Point)mousePosition).line;
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        TextAttributes color = editor.getColorsScheme().getAttributes(this.myKey);
        Color bgColor = color.getBackgroundColor();
        if (bgColor == null) {
            bgColor = color.getForegroundColor();
        }
        if (bgColor != null) {
            g.setColor(bgColor);
        }
        g.fillRect(r.x, r.y, r.width, r.height);
        LineData lineData = this.getLineData(this.getCurrentLineNumber(editor, new Point(0, r.y)));
        if (lineData != null && lineData.isCoveredByOneTest()) {
            AllIcons.Gutter.Unique.paintIcon(editor.getComponent(), g, r.x, r.y);
        }
    }

    public static CoverageLineMarkerRenderer getRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<? super Integer, Integer> newToOldConverter, Function<? super Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        return new CoverageLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, newToOldConverter, oldToNewConverter, coverageSuite, subCoverageActive);
    }

    public static TextAttributesKey getAttributesKey(int lineNumber, TreeMap<Integer, LineData> lines) {
        return CoverageLineMarkerRenderer.getAttributesKey(lines.get(lineNumber));
    }

    private static TextAttributesKey getAttributesKey(LineData lineData) {
        if (lineData != null) {
            switch (lineData.getStatus()) {
                case 2: {
                    return CodeInsightColors.LINE_FULL_COVERAGE;
                }
                case 1: {
                    return CodeInsightColors.LINE_PARTIAL_COVERAGE;
                }
            }
        }
        return CodeInsightColors.LINE_NONE_COVERAGE;
    }

    public boolean canDoAction(@NotNull MouseEvent e) {
        Component component = e.getComponent();
        if (component instanceof EditorGutterComponentEx) {
            EditorGutterComponentEx gutter = (EditorGutterComponentEx)component;
            return e.getX() > gutter.getLineMarkerAreaOffset() && e.getX() < gutter.getIconAreaOffset();
        }
        return false;
    }

    public void doAction(@NotNull Editor editor, @NotNull MouseEvent e) {
        e.consume();
        JComponent comp = (JComponent)e.getComponent();
        JRootPane rootPane = comp.getRootPane();
        JLayeredPane layeredPane = rootPane.getLayeredPane();
        Point point = SwingUtilities.convertPoint(comp, 8, e.getY(), layeredPane);
        this.showHint(editor, point, this.getCurrentLineNumber(editor, e.getPoint()));
    }

    private void showHint(Editor editor, Point mousePosition, int lineNumber) {
        EditorImpl uEditor;
        JPanel panel = new JPanel(new BorderLayout());
        final Disposable unregisterActionsDisposable = new Disposable(){

            public void dispose() {
            }
        };
        panel.add((Component)this.createActionsToolbar(editor, lineNumber, unregisterActionsDisposable), "North");
        LineData lineData = this.getLineData(lineNumber);
        if (lineData != null && lineData.getStatus() != 0 && !this.mySubCoverageActive) {
            EditorFactory factory = EditorFactory.getInstance();
            Document doc = factory.createDocument((CharSequence)this.getReport(editor, lineNumber));
            doc.setReadOnly(true);
            uEditor = (EditorImpl)factory.createEditor(doc, editor.getProject());
            panel.add((Component)EditorFragmentComponent.createEditorFragmentComponent((Editor)uEditor, (int)0, (int)doc.getLineCount(), (boolean)false, (boolean)false), "Center");
        } else {
            uEditor = null;
        }
        LightweightHint hint = new LightweightHint(panel){

            public void hide() {
                if (uEditor != null) {
                    EditorFactory.getInstance().releaseEditor((Editor)uEditor);
                }
                Disposer.dispose((Disposable)unregisterActionsDisposable);
                super.hide();
            }
        };
        Point point = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)new LogicalPosition(lineNumber, 0), (short)2);
        if (mousePosition != null) {
            point.x = mousePosition.x;
            point.y = mousePosition.y + Math.abs(point.y - mousePosition.y) % editor.getLineHeight();
        } else {
            Point p = editor.visualPositionToXY(editor.offsetToVisualPosition(0));
            EditorGutterComponentEx editorComponent = (EditorGutterComponentEx)editor.getGutter();
            JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
            point.x = SwingUtilities.convertPoint((Component)editorComponent, (int)8, (int)p.y, (Component)layeredPane).x;
        }
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, 58, -1, false, new HintHint(editor, point));
    }

    private String getReport(Editor editor, int lineNumber) {
        LineData lineData = this.getLineData(lineNumber);
        Document document2 = editor.getDocument();
        Project project2 = editor.getProject();
        assert (project2 != null);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
        assert (psiFile != null);
        int lineStartOffset = document2.getLineStartOffset(lineNumber);
        int lineEndOffset = document2.getLineEndOffset(lineNumber);
        return this.myCoverageSuite.getCoverageEngine().generateBriefReport(editor, psiFile, lineNumber, lineStartOffset, lineEndOffset, lineData);
    }

    protected JComponent createActionsToolbar(Editor editor, int lineNumber, Disposable parent) {
        AnAction byteCodeViewAction;
        JComponent editorComponent = editor.getComponent();
        DefaultActionGroup group = new DefaultActionGroup();
        GotoPreviousCoveredLineAction prevAction = new GotoPreviousCoveredLineAction(editor, lineNumber);
        GotoNextCoveredLineAction nextAction = new GotoNextCoveredLineAction(editor, lineNumber);
        group.add((AnAction)prevAction);
        group.add((AnAction)nextAction);
        prevAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(38, 9)), editorComponent);
        nextAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(40, 9)), editorComponent);
        Disposer.register((Disposable)parent, () -> {
            prevAction.unregisterCustomShortcutSet(editorComponent);
            nextAction.unregisterCustomShortcutSet(editorComponent);
        });
        LineData lineData = this.getLineData(lineNumber);
        if (this.myCoverageByTestApplicable) {
            group.add((AnAction)new ShowCoveringTestsAction(this.myClassName, lineData));
        }
        if ((byteCodeViewAction = ActionManager.getInstance().getAction("ByteCodeViewer")) != null) {
            group.add(byteCodeViewAction);
        }
        group.add((AnAction)new EditCoverageColorsAction(editor, lineNumber));
        group.add((AnAction)new HideCoverageInfoAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", (ActionGroup)group, true);
        JComponent toolbarComponent = toolbar.getComponent();
        Color background = ((EditorEx)editor).getBackgroundColor();
        Color foreground = editor.getColorsScheme().getColor(EditorColors.CARET_COLOR);
        toolbarComponent.setBackground(background);
        toolbarComponent.setBorder((Border)new ColoredSideBorder(foreground, foreground, lineData == null || lineData.getStatus() == 0 || this.mySubCoverageActive ? foreground : null, foreground, 1));
        toolbar.updateActionsImmediately();
        return toolbarComponent;
    }

    public void moveToLine(int lineNumber, Editor editor) {
        int firstOffset = editor.getDocument().getLineStartOffset(lineNumber);
        editor.getCaretModel().moveToOffset(firstOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        editor.getScrollingModel().runActionOnScrollingFinished(() -> this.showHint(editor, null, lineNumber));
    }

    @Nullable
    public LineData getLineData(int lineNumber) {
        return this.myLines != null ? this.myLines.get(this.myNewToOldConverter != null ? (Integer)this.myNewToOldConverter.fun((Object)lineNumber) : lineNumber) : null;
    }

    @Override
    public Color getErrorStripeColor(Editor editor) {
        return editor.getColorsScheme().getAttributes(this.myKey).getErrorStripeColor();
    }

    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.LEFT;
    }

    @NotNull
    public String getAccessibleName() {
        return "marker: code coverage";
    }

    private class EditCoverageColorsAction
    extends AnAction {
        private final Editor myEditor;
        private final int myLineNumber;

        private EditCoverageColorsAction(Editor editor, int lineNumber) {
            super("Edit coverage colors", "Edit coverage colors", AllIcons.General.EditColors);
            this.myEditor = editor;
            this.myLineNumber = lineNumber;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setVisible(CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber) != null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(@NotNull AnActionEvent e) {
            final GeneralColorsPage colorsPage = new GeneralColorsPage();
            final String fullDisplayName = "Editor | " + ApplicationBundle.message((String)"title.colors.and.fonts", (Object[])new Object[0]) + " | " + colorsPage.getDisplayName();
            ColorAndFontOptions colorAndFontOptions = new ColorAndFontOptions(){

                protected List<ColorAndFontPanelFactory> createPanelFactories() {
                    ColorAndFontPanelFactory panelFactory = new ColorAndFontPanelFactory(){

                        @NotNull
                        public NewColorAndFontPanel createPanel(@NotNull ColorAndFontOptions options) {
                            SimpleEditorPreview preview = new SimpleEditorPreview(options, (ColorSettingsPage)colorsPage);
                            return NewColorAndFontPanel.create((PreviewPanel)preview, (String)colorsPage.getDisplayName(), (ColorAndFontOptions)options, null, (ColorSettingsPage)colorsPage);
                        }

                        @NotNull
                        public String getPanelDisplayName() {
                            return fullDisplayName;
                        }
                    };
                    return Collections.singletonList(panelFactory);
                }
            };
            Configurable[] configurables = colorAndFontOptions.buildConfigurables();
            try {
                NewColorAndFontPanel page = colorAndFontOptions.findPage(fullDisplayName);
                SearchableConfigurable general = colorAndFontOptions.findSubConfigurable(GeneralColorsPage.class);
                if (general != null && page != null) {
                    LineData lineData = CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber);
                    ShowSettingsUtil.getInstance().editConfigurable(this.myEditor.getProject(), (Configurable)general, () -> page.selectOptionByType(CoverageLineMarkerRenderer.getAttributesKey(lineData).getExternalName()));
                }
            }
            finally {
                for (Configurable configurable : configurables) {
                    configurable.disposeUIResources();
                }
                colorAndFontOptions.disposeUIResources();
            }
        }
    }

    private abstract class BaseGotoCoveredLineAction
    extends AnAction {
        private final Editor myEditor;
        private final int myLineNumber;

        BaseGotoCoveredLineAction(Editor editor, int lineNumber) {
            this.myEditor = editor;
            this.myLineNumber = lineNumber;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Integer lineNumber = this.getLineEntry();
            if (lineNumber != null) {
                CoverageLineMarkerRenderer.this.moveToLine(lineNumber, this.myEditor);
            }
        }

        protected abstract int next(int var1, int var2);

        @Nullable
        private Integer getLineEntry() {
            Integer line;
            block3: {
                int newLine;
                ArrayList list = new ArrayList(CoverageLineMarkerRenderer.this.myLines.keySet());
                Collections.sort(list);
                int size = list.size();
                LineData data = CoverageLineMarkerRenderer.this.getLineData(this.myLineNumber);
                int currentStatus = data != null ? data.getStatus() : 0;
                int idx = list.indexOf(CoverageLineMarkerRenderer.this.myNewToOldConverter != null ? (Integer)CoverageLineMarkerRenderer.this.myNewToOldConverter.fun((Object)this.myLineNumber) : this.myLineNumber);
                if (idx < 0) {
                    return null;
                }
                while (true) {
                    int index;
                    Integer key;
                    if ((key = (Integer)list.get(index = this.next(idx, size))) == this.myLineNumber) {
                        return null;
                    }
                    LineData lineData = CoverageLineMarkerRenderer.this.getLineData(key);
                    idx = index;
                    if (lineData == null || lineData.getStatus() == currentStatus) continue;
                    line = (Integer)list.get(idx);
                    if (CoverageLineMarkerRenderer.this.myOldToNewConverter == null) break block3;
                    newLine = (Integer)CoverageLineMarkerRenderer.this.myOldToNewConverter.fun((Object)line);
                    if (newLine != 0) break;
                }
                return newLine;
            }
            return line;
        }

        @Nullable
        protected String getNextChange() {
            LineData lineData;
            Integer entry = this.getLineEntry();
            if (entry != null && (lineData = CoverageLineMarkerRenderer.this.getLineData(entry)) != null) {
                switch (lineData.getStatus()) {
                    case 0: {
                        return "Uncovered";
                    }
                    case 1: {
                        return "Partial Covered";
                    }
                    case 2: {
                        return "Fully Covered";
                    }
                }
            }
            return null;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.getLineEntry() != null);
        }
    }

    private class GotoNextCoveredLineAction
    extends BaseGotoCoveredLineAction {
        GotoNextCoveredLineAction(Editor editor, int lineNumber) {
            super(editor, lineNumber);
            this.copyFrom(ActionManager.getInstance().getAction("NextOccurence"));
            this.getTemplatePresentation().setText("Next Coverage Mark");
        }

        @Override
        protected int next(int idx, int size) {
            if (idx == size - 1) {
                return 0;
            }
            return idx + 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            String nextChange = this.getNextChange();
            if (nextChange != null) {
                e.getPresentation().setText("Next " + nextChange);
            }
        }
    }

    private class GotoPreviousCoveredLineAction
    extends BaseGotoCoveredLineAction {
        GotoPreviousCoveredLineAction(Editor editor, int lineNumber) {
            super(editor, lineNumber);
            this.copyFrom(ActionManager.getInstance().getAction("PreviousOccurence"));
            this.getTemplatePresentation().setText("Previous Coverage Mark");
        }

        @Override
        protected int next(int idx, int size) {
            if (idx <= 0) {
                return size - 1;
            }
            return idx - 1;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            String nextChange = this.getNextChange();
            if (nextChange != null) {
                e.getPresentation().setText("Previous " + nextChange);
            }
        }
    }
}

