/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CoverageSuite
extends JDOMExternalizable {
    public boolean isValid();

    @NotNull
    public String getCoverageDataFileName();

    public String getPresentableName();

    public long getLastCoverageTimeStamp();

    @NotNull
    public CoverageFileProvider getCoverageDataFileProvider();

    public boolean isCoverageByTestApplicable();

    public boolean isCoverageByTestEnabled();

    @Nullable
    public ProjectData getCoverageData(CoverageDataManager var1);

    public void setCoverageData(ProjectData var1);

    public void restoreCoverageData();

    public boolean isTrackTestFolders();

    public boolean isTracingEnabled();

    public CoverageRunner getRunner();

    @NotNull
    public CoverageEngine getCoverageEngine();

    public Project getProject();

    default public boolean canRemove() {
        CoverageFileProvider provider2 = this.getCoverageDataFileProvider();
        return provider2 instanceof DefaultCoverageFileProvider && Comparing.strEqual((String)((DefaultCoverageFileProvider)provider2).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName());
    }

    default public void deleteCachedCoverageData() {
        File file;
        String fileName = this.getCoverageDataFileName();
        if (!FileUtil.isAncestor((String)PathManager.getSystemPath(), (String)fileName, (boolean)false)) {
            String message = "Would you like to delete file '" + fileName + "' on disk?";
            if (Messages.showYesNoDialog((Project)this.getProject(), (String)message, (String)CommonBundle.getWarningTitle(), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        if ((file = new File(fileName)).exists()) {
            FileUtil.delete((File)file);
        }
        this.getCoverageEngine().deleteAssociatedTraces(this);
    }
}

