/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithText;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ShowCoveringTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ShowCoveringTestsAction.class);
    private final String myClassFQName;
    private final LineData myLineData;

    public ShowCoveringTestsAction(String classFQName, LineData lineData) {
        super("Show tests covering line", "Show tests covering line", PlatformIcons.TEST_SOURCE_FOLDER);
        this.myClassFQName = classFQName;
        this.myLineData = lineData;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        LOG.assertTrue(project2 != null);
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        LOG.assertTrue(editor != null);
        CoverageSuitesBundle currentSuite = CoverageDataManager.getInstance(project2).getCurrentSuitesBundle();
        LOG.assertTrue(currentSuite != null);
        CoverageEngine coverageEngine = currentSuite.getCoverageEngine();
        HashSet tests = new HashSet();
        if (((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> tests.addAll(coverageEngine.getTestsForLine(project2, this.myClassFQName, this.myLineData.getLineNumber())), "Extract Information About Tests", false, project2)).booleanValue()) {
            ComponentPopupBuilder popupBuilder;
            ImplementationViewComponent component;
            Object[] testNames = ArrayUtil.toStringArray(tests);
            Arrays.sort(testNames);
            if (testNames.length == 0) {
                HintManager.getInstance().showErrorHint(editor, "Failed to load covered tests");
                return;
            }
            List<PsiElement> elements = coverageEngine.findTestsByNames((String[])testNames, project2);
            String title = "Tests covering line " + this.myClassFQName + ":" + this.myLineData.getLineNumber();
            if (!elements.isEmpty()) {
                component = new ImplementationViewComponent((Collection)ContainerUtil.map(elements, PsiImplementationViewElement::new), 0);
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getPreferredFocusableComponent()).setDimensionServiceKey(project2, "ShowTestsPopup", false).setCouldPin(popup -> {
                    component.showInUsageView();
                    popup.cancel();
                    return false;
                });
            } else {
                component = null;
                PanelWithText panel = new PanelWithText("Following test" + (testNames.length > 1 ? "s" : "") + " could not be found: " + StringUtil.join((String[])testNames, (String)"<br/>").replace("_", "."));
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel, null);
            }
            JBPopup popup2 = popupBuilder.setRequestFocusCondition(project2, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project2).setResizable(true).setMovable(true).setTitle(title).createPopup();
            popup2.showInBestPositionFor(editor);
            if (component != null) {
                component.setHint(popup2, title);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2;
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(false);
        if (this.myLineData != null && this.myLineData.getStatus() != 0 && (project2 = e.getProject()) != null) {
            CoverageSuitesBundle currentSuitesBundle = CoverageDataManager.getInstance(project2).getCurrentSuitesBundle();
            presentation.setEnabled(currentSuitesBundle.isCoverageByTestEnabled() && currentSuitesBundle.getCoverageEngine().wasTestDataCollected(project2));
        }
    }
}

