/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.commander.AbstractListBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.SortableColumnModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

class CoverageTableModel
extends AbstractTableModel
implements AbstractListBuilder.Model,
SortableColumnModel {
    private final ColumnInfo[] COLUMN_INFOS;
    final List myElements = new ArrayList();

    CoverageTableModel(@NotNull CoverageSuitesBundle suitesBundle, CoverageViewManager.StateBean stateBean, Project project2) {
        CoverageEngine coverageEngine = suitesBundle.getCoverageEngine();
        this.COLUMN_INFOS = coverageEngine.createCoverageViewExtension(project2, suitesBundle, stateBean).createColumnInfos();
    }

    public void removeAllElements() {
        this.myElements.clear();
        this.fireTableDataChanged();
    }

    public void addElement(Object obj) {
        this.myElements.add(obj);
        this.fireTableDataChanged();
    }

    public void replaceElements(List newElements) {
        this.removeAllElements();
        this.myElements.addAll(newElements);
        this.fireTableDataChanged();
    }

    public Object[] toArray() {
        return ArrayUtil.toObjectArray((Collection)this.myElements);
    }

    public int indexOf(Object o) {
        return this.myElements.indexOf(o);
    }

    public int getSize() {
        return this.myElements.size();
    }

    public Object getElementAt(int index) {
        return this.myElements.get(index);
    }

    @Override
    public int getRowCount() {
        return this.myElements.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMN_INFOS.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.COLUMN_INFOS[column].getName();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object element = this.getElementAt(rowIndex);
        if (columnIndex == 0) {
            return element;
        }
        if (element instanceof CoverageListNode) {
            return this.COLUMN_INFOS[columnIndex].valueOf(element);
        }
        return element;
    }

    public ColumnInfo[] getColumnInfos() {
        return this.COLUMN_INFOS;
    }

    public void setSortable(boolean aBoolean) {
    }

    public boolean isSortable() {
        return true;
    }

    public Object getRowValue(int row) {
        return this.getElementAt(row);
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return null;
    }
}

