/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerInvocationUtil {
    public static void swingInvokeLater(@Nullable Project project2, @NotNull Runnable runnable) {
        if (project2 == null) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            if (!project2.isDisposed()) {
                runnable.run();
            }
        });
    }

    public static void invokeLater(@Nullable Project project2, @NotNull Runnable runnable) {
        if (project2 != null) {
            ApplicationManager.getApplication().invokeLater(runnable, project2.getDisposed());
        }
    }

    public static void invokeLater(@Nullable Project project2, @NotNull Runnable runnable, ModalityState state) {
        if (project2 != null) {
            ApplicationManager.getApplication().invokeLater(runnable, state, project2.getDisposed());
        }
    }

    public static void invokeAndWait(Project project2, @NotNull Runnable runnable, ModalityState state) {
        if (project2 != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (!project2.isDisposed()) {
                    runnable.run();
                }
            }, state);
        }
    }

    public static <T> T commitAndRunReadAction(Project project2, EvaluatingComputable<T> computable) throws EvaluateException {
        Throwable[] ex = new Throwable[]{null};
        Object result = PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            try {
                return computable.compute();
            }
            catch (EvaluateException | RuntimeException e) {
                ex[0] = e;
                return null;
            }
        });
        if (ex[0] != null) {
            if (ex[0] instanceof RuntimeException) {
                throw (RuntimeException)ex[0];
            }
            throw (EvaluateException)ex[0];
        }
        return (T)result;
    }
}

