/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JvmSmartStepIntoActionHandler
extends DebuggerActionHandler {
    public void perform(@NotNull Project project2, AnActionEvent event) {
        DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession session = debuggerContext.getDebuggerSession();
        if (session != null) {
            JvmSmartStepIntoActionHandler.doStep(project2, debuggerContext.getSourcePosition(), session);
        }
    }

    private static void doStep(@NotNull Project project2, @Nullable SourcePosition position, @NotNull DebuggerSession session) {
        FileEditor fileEditor;
        VirtualFile file = position != null ? position.getFile().getVirtualFile() : null;
        FileEditor fileEditor2 = fileEditor = file != null ? FileEditorManager.getInstance((Project)project2).getSelectedEditor(file) : null;
        if (fileEditor instanceof TextEditor) {
            for (JvmSmartStepIntoHandler handler : JvmSmartStepIntoHandler.EP_NAME.getExtensionList()) {
                if (!handler.isAvailable(position) || !handler.doSmartStep(position, session, (TextEditor)fileEditor)) continue;
                return;
            }
        }
        JvmSmartStepIntoActionHandler.doStepInto(session, Registry.is((String)"debugger.single.smart.step.force"), null);
    }

    static void doStepInto(DebuggerSession session, boolean force, MethodFilter filter) {
        session.sessionResumed();
        session.stepInto(force, filter);
    }

    public boolean isEnabled(@NotNull Project project2, AnActionEvent event) {
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession debuggerSession = context.getDebuggerSession();
        boolean isPaused = debuggerSession != null && debuggerSession.isPaused();
        SuspendContextImpl suspendContext = context.getSuspendContext();
        boolean hasCurrentThread = suspendContext != null && suspendContext.getThread() != null;
        return isPaused && hasCurrentThread;
    }
}

