/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepOutOfBlockAction
extends DebuggerAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        XDebugSession session = StepOutOfBlockAction.getSession(e);
        if (session != null) {
            StepOutOfBlockAction.doStepOutOfBlock(session);
        }
    }

    private static void doStepOutOfBlock(@NotNull XDebugSession xSession) {
        XDebugProcess process2 = xSession.getDebugProcess();
        if (process2 instanceof JavaDebugProcess) {
            DebuggerContextImpl debuggerContext = ((JavaDebugProcess)process2).getDebuggerSession().getContextManager().getContext();
            DebuggerSession session = debuggerContext.getDebuggerSession();
            SourcePosition position = debuggerContext.getSourcePosition();
            if (position != null && session != null) {
                PsiElement element = position.getElementAt();
                PsiElement block = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiCodeBlock.class, PsiLambdaExpression.class});
                if (block instanceof PsiCodeBlock) {
                    PsiElement parent = block.getParent();
                    if (parent instanceof PsiMethod || parent instanceof PsiLambdaExpression) {
                        xSession.stepOut();
                    } else {
                        TextRange textRange = block.getTextRange();
                        Document document2 = FileDocumentManager.getInstance().getDocument(position.getFile().getVirtualFile());
                        if (document2 != null) {
                            int startLine = document2.getLineNumber(textRange.getStartOffset());
                            int endLine = document2.getLineNumber(textRange.getEndOffset());
                            session.sessionResumed();
                            session.stepOver(false, new BlockFilter(startLine, endLine), -2);
                        }
                    }
                } else {
                    xSession.stepOut();
                }
            }
        }
    }

    public static void stepOutOfBlock(@NotNull XDebugSession xSession) {
        StepOutOfBlockAction.doStepOutOfBlock(xSession);
    }

    public void update(@NotNull AnActionEvent e) {
        XDebugSession session = StepOutOfBlockAction.getSession(e);
        e.getPresentation().setEnabledAndVisible(session != null && session.getDebugProcess() instanceof JavaDebugProcess && !((XDebugSessionImpl)session).isReadOnly() && session.isSuspended());
    }

    private static class BlockFilter
    implements MethodFilter {
        private final Range<Integer> myLines;

        private BlockFilter(int startLine, int endLine) {
            this.myLines = new Range((Comparable)Integer.valueOf(startLine), (Comparable)Integer.valueOf(endLine));
        }

        @Override
        public boolean locationMatches(DebugProcessImpl process2, Location location) {
            return false;
        }

        @Override
        @Nullable
        public Range<Integer> getCallingExpressionLines() {
            return this.myLines;
        }
    }
}

