/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SwitchToTheNextContextAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        final DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl process2 = debuggerContext.getDebugProcess();
        if (process2 == null) {
            return;
        }
        process2.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                List<SuspendContextImpl> pausedContexts = ((SuspendManagerImpl)process2.getSuspendManager()).getPausedContexts();
                if (pausedContexts.size() > 1) {
                    int currentIndex = pausedContexts.indexOf((Object)debuggerContext.getSuspendContext());
                    int newIndex = (currentIndex + 1) % pausedContexts.size();
                    process2.getManagerThread().schedule(new SuspendContextCommandImpl(pausedContexts.get(newIndex)){

                        @Override
                        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                            DebuggerSession.switchContext(suspendContext);
                        }
                    });
                }
            }
        });
    }
}

