/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.XExpressionDialog;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowExceptionAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project2 = e.getProject();
        final JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame == null || project2 == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        StackFrameProxyImpl proxy = stackFrame.getStackFrameProxy();
        ThreadReferenceProxyImpl thread = proxy.threadProxy();
        debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext, thread){

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                ApplicationManager.getApplication().invokeLater(() -> new XExpressionDialog(project2, debugProcess.getXdebugProcess().getEditorsProvider(), "throwExceptionValue", "Exception To Throw", stackFrame.getSourcePosition(), null){

                    protected void doOKAction() {
                        ThrowExceptionAction.evaluateAndReturn(project2, stackFrame, debugProcess, this.getExpression(), (DialogWrapper)this);
                    }
                }.show());
            }
        });
    }

    private static void throwException(final Value value, final ThreadReferenceProxyImpl thread, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                try {
                    thread.stop((ObjectReference)value);
                }
                catch (Exception e) {
                    ThrowExceptionAction.showError(debugProcess.getProject(), DebuggerBundle.message((String)"error.throw.exception", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    if (dialog != null) {
                        dialog.close(0);
                    }
                    debugProcess.getSession().stepInto(true, null);
                });
            }
        });
    }

    private static void showError(Project project2, String message) {
        PopFrameAction.showError(project2, message, UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ThrowException")));
    }

    private static void evaluateAndReturn(final Project project2, final JavaStackFrame stackFrame, final DebugProcessImpl debugProcess, XExpression expression, final DialogWrapper dialog) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate(expression, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result instanceof JavaValue) {
                        ThrowExceptionAction.throwException(((JavaValue)result).getDescriptor().getValue(), stackFrame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
                    }
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    ThrowExceptionAction.showError(project2, DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + ": " + errorMessage);
                }
            }, stackFrame.getSourcePosition());
        } else {
            ThrowExceptionAction.showError(project2, XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enable;
        JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        boolean bl = enable = stackFrame != null && stackFrame.getDescriptor().getUiIndex() == 0;
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }
}

