/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.PlaceInDocument;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleMethodBreakpointAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        boolean toEnable;
        boolean bl = toEnable = ToggleMethodBreakpointAction.getPlace(event) != null;
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            event.getPresentation().setVisible(toEnable);
        } else {
            event.getPresentation().setEnabled(toEnable);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        DebuggerManagerEx debugManager = DebuggerManagerEx.getInstanceEx(project2);
        if (debugManager == null) {
            return;
        }
        BreakpointManager manager = debugManager.getBreakpointManager();
        PlaceInDocument place = ToggleMethodBreakpointAction.getPlace(e);
        if (place != null && DocumentUtil.isValidOffset((int)place.getOffset(), (Document)place.getDocument())) {
            MethodBreakpoint breakpoint = manager.findBreakpoint(place.getDocument(), place.getOffset(), MethodBreakpoint.CATEGORY);
            if (breakpoint == null) {
                manager.addMethodBreakpoint(place.getDocument(), place.getDocument().getLineNumber(place.getOffset()));
            } else {
                manager.removeBreakpoint(breakpoint);
            }
        }
    }

    @Nullable
    private static PlaceInDocument getPlace(AnActionEvent event) {
        Project project2 = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return null;
        }
        PsiElement method = null;
        Document document2 = null;
        if ("ProjectViewPopup".equals(event.getPlace()) || "StructureViewPopup".equals(event.getPlace()) || "FavoritesPopup".equals(event.getPlace()) || "NavBar".equals(event.getPlace())) {
            PsiFile containingFile;
            PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_ELEMENT);
            if (psiElement instanceof PsiMethod && (containingFile = psiElement.getContainingFile()) != null) {
                method = psiElement;
                document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(containingFile);
            }
        } else {
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
            }
            if (editor != null) {
                document2 = editor.getDocument();
                PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document2);
                if (file != null) {
                    FileType fileType;
                    VirtualFile virtualFile = file.getVirtualFile();
                    FileType fileType2 = fileType = virtualFile != null ? virtualFile.getFileType() : null;
                    if (StdFileTypes.JAVA == fileType || StdFileTypes.CLASS == fileType) {
                        method = ToggleMethodBreakpointAction.findMethod(project2, editor);
                    }
                }
            }
        }
        return method != null ? new PlaceInDocument(document2, method.getTextOffset()) : null;
    }

    @Nullable
    private static PsiMethod findMethod(Project project2, Editor editor) {
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        int offset = CharArrayUtil.shiftForward((CharSequence)editor.getDocument().getCharsSequence(), (int)editor.getCaretModel().getOffset(), (String)" \t");
        return DebuggerUtilsEx.findPsiMethod(psiFile, offset);
    }
}

