/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.settings.CaptureSettingsProvider;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncStacksUtils {
    private static final Logger LOG = Logger.getInstance(AsyncStacksUtils.class);
    public static final String CAPTURE_STORAGE_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureStorage";
    public static final String CAPTURE_AGENT_CLASS_NAME = "com.intellij.rt.debugger.agent.CaptureAgent";
    private static final Key<Pair<ClassType, Method>> CAPTURE_STORAGE_METHOD = Key.create((String)"CAPTURE_STORAGE_METHOD");
    private static final Pair<ClassType, Method> NO_CAPTURE_AGENT = Pair.empty();

    public static boolean isAgentEnabled() {
        return DebuggerSettings.getInstance().INSTRUMENTING_AGENT;
    }

    @Nullable
    public static List<StackFrameItem> getAgentRelatedStack(JavaStackFrame frame, @NotNull SuspendContextImpl suspendContext) {
        Method method;
        Location location;
        if (AsyncStacksUtils.isAgentEnabled() && suspendContext.getDebugProcess().isEvaluationPossible(suspendContext) && (location = frame.getDescriptor().getLocation()) != null && (method = DebuggerUtilsEx.getMethod(location)) != null && method.name().endsWith("$$$capture")) {
            try {
                return AsyncStacksUtils.getProcessCapturedStack(new EvaluationContextImpl(suspendContext, frame.getStackFrameProxy()));
            }
            catch (EvaluateException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    private static List<StackFrameItem> getProcessCapturedStack(EvaluationContextImpl evalContext) throws EvaluateException {
        EvaluationContextImpl evaluationContext = evalContext.withAutoLoadClasses(false);
        DebugProcessImpl process2 = evaluationContext.getDebugProcess();
        Pair methodPair = (Pair)process2.getUserData(CAPTURE_STORAGE_METHOD);
        if (methodPair == null) {
            try {
                ClassType captureClass = (ClassType)process2.findClass(evaluationContext, CAPTURE_STORAGE_CLASS_NAME, null);
                if (captureClass == null) {
                    methodPair = NO_CAPTURE_AGENT;
                    LOG.debug("Error loading debug agent", new Object[]{"agent class not found"});
                } else {
                    methodPair = Pair.create((Object)captureClass, (Object)captureClass.methodsByName("getCurrentCapturedStack").get(0));
                }
            }
            catch (EvaluateException e) {
                methodPair = NO_CAPTURE_AGENT;
                LOG.debug("Error loading debug agent", (Throwable)e);
            }
            AsyncStacksUtils.putProcessUserData(CAPTURE_STORAGE_METHOD, methodPair, process2);
        }
        if (methodPair == NO_CAPTURE_AGENT) {
            return null;
        }
        Pair finalMethodPair = methodPair;
        VirtualMachineProxyImpl virtualMachineProxy = process2.getVirtualMachineProxy();
        List<IntegerValue> args = Collections.singletonList(virtualMachineProxy.mirrorOf(AsyncStacksUtils.getMaxStackLength()));
        Object resArray = evaluationContext.computeAndKeep(() -> process2.invokeMethod(evaluationContext, (ClassType)finalMethodPair.first, (Method)finalMethodPair.second, args, 1, true));
        if (resArray instanceof ArrayReference) {
            List<Value> values = ((ArrayReference)resArray).getValues();
            ArrayList<StackFrameItem> res = new ArrayList<StackFrameItem>(values.size());
            ClassesByNameProvider classesByName = ClassesByNameProvider.createCache(virtualMachineProxy.allClasses());
            for (Value value : values) {
                if (value == null) {
                    res.add(null);
                    continue;
                }
                List<Value> values1 = ((ArrayReference)value).getValues();
                String className = AsyncStacksUtils.getStringRefValue((StringReference)values1.get(0));
                String methodName = AsyncStacksUtils.getStringRefValue((StringReference)values1.get(2));
                int line = Integer.parseInt(((StringReference)values1.get(3)).value());
                Location location = AsyncStacksUtils.findLocation(process2, (ReferenceType)ContainerUtil.getFirstItem(classesByName.get(className)), methodName, line);
                res.add(new ProcessStackFrameItem(location, className, methodName));
            }
            return res;
        }
        return null;
    }

    private static String getStringRefValue(StringReference ref) {
        return ref != null ? ref.value() : null;
    }

    public static void setupAgent(final DebugProcessImpl process2) {
        Properties properties;
        if (!AsyncStacksUtils.isAgentEnabled()) {
            return;
        }
        if (Registry.is((String)"debugger.capture.points.agent.debug")) {
            AsyncStacksUtils.enableAgentDebug(process2);
        }
        if (DebuggerUtilsImpl.isRemote(process2) && !(properties = CaptureSettingsProvider.getPointsProperties()).isEmpty()) {
            process2.addDebugProcessListener(new DebugProcessAdapterImpl(){

                @Override
                public void paused(SuspendContextImpl suspendContext) {
                    if (process2.isEvaluationPossible()) {
                        try {
                            StackCapturingLineBreakpoint.deleteAll(process2);
                            try {
                                AsyncStacksUtils.addAgentCapturePoints(new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy()), properties);
                                process2.removeDebugProcessListener(this);
                            }
                            finally {
                                process2.onHotSwapFinished();
                                StackCapturingLineBreakpoint.createAll(process2);
                            }
                        }
                        catch (Exception e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private static void enableAgentDebug(final DebugProcessImpl process2) {
        final RequestManagerImpl requestsManager = process2.getRequestsManager();
        ClassPrepareRequestor requestor = new ClassPrepareRequestor(){

            public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                try {
                    requestsManager.deleteRequest((Requestor)this);
                    ((ClassType)referenceType).setValue(referenceType.fieldByName("DEBUG"), process2.getVirtualMachineProxy().mirrorOf(true));
                }
                catch (Exception e) {
                    LOG.warn("Error setting agent debug mode", (Throwable)e);
                }
            }
        };
        requestsManager.callbackOnPrepareClasses(requestor, CAPTURE_STORAGE_CLASS_NAME);
        try {
            ClassType captureClass = (ClassType)process2.findClass(null, CAPTURE_STORAGE_CLASS_NAME, null);
            if (captureClass != null) {
                requestor.processClassPrepare((DebugProcess)process2, (ReferenceType)captureClass);
            }
        }
        catch (Exception e) {
            LOG.warn("Error setting agent debug mode", (Throwable)e);
        }
    }

    private static Location findLocation(DebugProcessImpl debugProcess, ReferenceType type, String methodName, int line) {
        if (type != null && line >= 0) {
            try {
                Location location = type.locationsOfLine("Java", null, line).stream().filter(l -> l.method().name().equals(methodName)).findFirst().orElse(null);
                if (location != null) {
                    return location;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return new GeneratedLocation(debugProcess, type, methodName, line);
    }

    public static void addAgentCapturePoints(EvaluationContextImpl evalContext, Properties properties) {
        EvaluationContextImpl evaluationContext = evalContext.withAutoLoadClasses(false);
        DebugProcessImpl process2 = evaluationContext.getDebugProcess();
        try {
            ClassType captureClass = (ClassType)process2.findClass(evaluationContext, CAPTURE_AGENT_CLASS_NAME, null);
            if (captureClass == null) {
                LOG.debug("Error loading debug agent", new Object[]{"agent class not found"});
            } else {
                Method method = captureClass.methodsByName("addCapturePoints").get(0);
                if (method != null) {
                    StringWriter writer = new StringWriter();
                    try {
                        properties.store(writer, null);
                        List<StringReference> args = Collections.singletonList(DebuggerUtilsEx.mirrorOfString(writer.toString(), process2.getVirtualMachineProxy(), evalContext));
                        process2.invokeMethod(evaluationContext, captureClass, method, args, 1, true);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        catch (EvaluateException e) {
            LOG.debug("Error loading debug agent", (Throwable)e);
        }
    }

    public static <T> void putProcessUserData(final @NotNull Key<T> key, @Nullable T value, DebugProcessImpl debugProcess) {
        debugProcess.putUserData(key, value);
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(@NotNull DebugProcess process2, boolean closedByUser) {
                process2.putUserData(key, null);
            }
        });
    }

    public static int getMaxStackLength() {
        return Registry.intValue((String)"debugger.async.stacks.max.depth", (int)500);
    }

    private static class ProcessStackFrameItem
    extends StackFrameItem {
        final String myClass;
        final String myMethod;

        ProcessStackFrameItem(Location location, String aClass, String method) {
            super(location, null);
            this.myClass = aClass;
            this.myMethod = method;
        }

        @Override
        @NotNull
        public String path() {
            return this.myClass;
        }

        @Override
        @NotNull
        public String method() {
            return this.myMethod;
        }

        @Override
        public String toString() {
            return this.myClass + "." + this.myMethod + ":" + this.line();
        }
    }
}

