/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.AnonymousClassMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ConstructorStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public class ClassInstanceMethodFilter
extends ConstructorStepMethodFilter {
    private final BreakpointStepMethodFilter myMethodFilter;

    public ClassInstanceMethodFilter(PsiMethod psiMethod, Range<Integer> lines) {
        super(psiMethod.getContainingClass(), lines);
        this.myMethodFilter = new AnonymousClassMethodFilter(psiMethod, this.getCallingExpressionLines());
    }

    @Override
    public int onReached(SuspendContextImpl context, RequestHint hint) {
        StackFrameProxyImpl proxy = context.getFrameProxy();
        if (proxy != null) {
            try {
                StepIntoBreakpoint breakpoint;
                ObjectReference reference = proxy.thisObject();
                if (reference != null && (breakpoint = DebuggerManagerEx.getInstanceEx(context.getDebugProcess().getProject()).getBreakpointManager().addStepIntoBreakpoint(this.myMethodFilter)) != null) {
                    breakpoint.addInstanceFilter(reference.uniqueID());
                    breakpoint.setInstanceFiltersEnabled(true);
                    ClassInstanceMethodFilter.setUpStepIntoBreakpoint(context, breakpoint, hint);
                    return -100;
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return 0;
    }

    static void setUpStepIntoBreakpoint(SuspendContextImpl context, @NotNull StepIntoBreakpoint breakpoint, RequestHint hint) {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(debugProcess.getProject()).getBreakpointManager();
        breakpointManager.applyThreadFilter(debugProcess, null);
        breakpoint.setSuspendPolicy(context.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll");
        breakpoint.createRequest(debugProcess);
        breakpoint.setRequestHint(hint);
        debugProcess.setRunToCursorBreakpoint(breakpoint);
    }
}

