/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JVMNameUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.JVMNameUtil");
    public static final String CONSTRUCTOR_NAME = "<init>";

    @Nullable
    public static String getPrimitiveSignature(String typeName) {
        if (PsiType.BOOLEAN.getCanonicalText().equals(typeName)) {
            return "Z";
        }
        if (PsiType.BYTE.getCanonicalText().equals(typeName)) {
            return "B";
        }
        if (PsiType.CHAR.getCanonicalText().equals(typeName)) {
            return "C";
        }
        if (PsiType.SHORT.getCanonicalText().equals(typeName)) {
            return "S";
        }
        if (PsiType.INT.getCanonicalText().equals(typeName)) {
            return "I";
        }
        if (PsiType.LONG.getCanonicalText().equals(typeName)) {
            return "J";
        }
        if (PsiType.FLOAT.getCanonicalText().equals(typeName)) {
            return "F";
        }
        if (PsiType.DOUBLE.getCanonicalText().equals(typeName)) {
            return "D";
        }
        if (PsiType.VOID.getCanonicalText().equals(typeName)) {
            return "V";
        }
        return null;
    }

    private static void appendJVMSignature(JVMNameBuffer buffer, PsiType type) {
        if (type == null) {
            return;
        }
        PsiType psiType = TypeConversionUtil.erasure((PsiType)type);
        if (psiType instanceof PsiArrayType) {
            buffer.append(new JVMRawText("["));
            JVMNameUtil.appendJVMSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            JVMName jvmName = JVMNameUtil.getJVMQualifiedName(psiType);
            JVMNameUtil.appendJvmClassQualifiedName(buffer, jvmName);
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JVMNameUtil.getPrimitiveSignature(psiType.getCanonicalText()));
        } else {
            LOG.error("unknown type " + type.getCanonicalText());
        }
    }

    private static void appendJvmClassQualifiedName(JVMNameBuffer buffer, final JVMName jvmName) {
        buffer.append("L");
        if (jvmName instanceof JVMRawText) {
            buffer.append(((JVMRawText)jvmName).getName().replace('.', '/'));
        } else {
            buffer.append(new JVMName(){

                @Override
                public String getName(DebugProcessImpl process2) throws EvaluateException {
                    return jvmName.getName(process2).replace('.', '/');
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    return jvmName.getDisplayName(debugProcess);
                }
            });
        }
        buffer.append(";");
    }

    @NotNull
    public static JVMName getJVMRawText(String qualifiedName) {
        return new JVMRawText(qualifiedName);
    }

    public static JVMName getJVMQualifiedName(PsiType psiType) {
        if (psiType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)psiType;
            JVMName jvmName = JVMNameUtil.getJVMQualifiedName(arrayType.getComponentType());
            JVMNameBuffer buffer = new JVMNameBuffer();
            buffer.append(jvmName);
            buffer.append("[]");
            return buffer.toName();
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass == null) {
            return JVMNameUtil.getJVMRawText(psiType.getCanonicalText());
        }
        return JVMNameUtil.getJVMQualifiedName(psiClass);
    }

    @NotNull
    public static JVMName getJVMQualifiedName(@NotNull PsiClass psiClass) {
        String name2 = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (name2 != null) {
            return JVMNameUtil.getJVMRawText(name2);
        }
        return new JVMClassAt(SourcePosition.createFromElement((PsiElement)psiClass));
    }

    @Nullable
    public static JVMName getContextClassJVMQualifiedName(@Nullable SourcePosition pos) {
        PsiClass psiClass = JVMNameUtil.getClassAt(pos);
        if (psiClass == null) {
            return null;
        }
        String name2 = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (name2 != null) {
            return JVMNameUtil.getJVMRawText(name2);
        }
        return new JVMClassAt(pos);
    }

    @Nullable
    public static String getNonAnonymousClassName(@NotNull PsiClass aClass) {
        if (PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            return null;
        }
        String name2 = aClass.getName();
        if (name2 == null) {
            return null;
        }
        PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parentClass != null) {
            String parentName = JVMNameUtil.getNonAnonymousClassName(parentClass);
            if (parentName == null) {
                return null;
            }
            return parentName + "$" + name2;
        }
        return DebuggerManager.getInstance((Project)aClass.getProject()).getVMClassQualifiedName(aClass);
    }

    @NotNull
    public static JVMName getJVMConstructorSignature(@Nullable PsiMethod method, @Nullable PsiClass declaringClass) {
        return JVMNameUtil.getJVMSignature(method, true, declaringClass);
    }

    @NotNull
    public static JVMName getJVMSignature(@NotNull PsiMethod method) {
        return JVMNameUtil.getJVMSignature(method, method.isConstructor(), method.getContainingClass());
    }

    @NotNull
    public static String getJVMMethodName(@NotNull PsiMethod method) {
        return method.isConstructor() ? CONSTRUCTOR_NAME : method.getName();
    }

    @NotNull
    private static JVMName getJVMSignature(@Nullable PsiMethod method, boolean constructor, @Nullable PsiClass declaringClass) {
        PsiClass outerClass;
        JVMNameBuffer signature = new JVMNameBuffer();
        signature.append("(");
        if (constructor && declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static")) {
            JVMNameUtil.appendJvmClassQualifiedName(signature, JVMNameUtil.getJVMQualifiedName(outerClass));
        }
        if (method != null) {
            for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
                JVMNameUtil.appendJVMSignature(signature, psiParameter.getType());
            }
        }
        signature.append(")");
        if (!constructor && method != null) {
            JVMNameUtil.appendJVMSignature(signature, method.getReturnType());
        } else {
            signature.append(new JVMRawText("V"));
        }
        return signature.toName();
    }

    @Nullable
    public static PsiClass getClassAt(@Nullable SourcePosition position) {
        if (position == null) {
            return null;
        }
        PsiElement element = position.getElementAt();
        return element != null && element.isValid() ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false) : null;
    }

    @Nullable
    public static String getSourcePositionClassDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        List<ReferenceType> allClasses;
        String qName;
        if (position == null) {
            return null;
        }
        PsiFile positionFile = position.getFile();
        if (positionFile instanceof JspFile) {
            return positionFile.getName();
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(position);
        if (psiClass != null && (qName = psiClass.getQualifiedName()) != null) {
            return qName;
        }
        if (debugProcess != null && debugProcess.isAttached() && !(allClasses = debugProcess.getPositionManager().getAllClasses(position)).isEmpty()) {
            return allClasses.get(0).name();
        }
        if (psiClass == null) {
            if (positionFile instanceof PsiClassOwner) {
                return positionFile.getName();
            }
            return DebuggerBundle.message((String)"string.file.line.position", (Object[])new Object[]{positionFile.getName(), position.getLine()});
        }
        return JVMNameUtil.calcClassDisplayName(psiClass);
    }

    static String calcClassDisplayName(final PsiClass aClass) {
        String qName = aClass.getQualifiedName();
        if (qName != null) {
            return qName;
        }
        PsiClass parent = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        if (parent == null) {
            return null;
        }
        String name2 = aClass.getName();
        if (name2 != null) {
            return JVMNameUtil.calcClassDisplayName(parent) + "$" + name2;
        }
        final Ref classIndex = new Ref((Object)0);
        try {
            parent.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitAnonymousClass(PsiAnonymousClass cls) {
                    classIndex.set((Object)((Integer)classIndex.get() + 1));
                    if (aClass.equals(cls)) {
                        throw new ProcessCanceledException();
                    }
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return JVMNameUtil.calcClassDisplayName(parent) + "$" + classIndex.get();
    }

    @Nullable
    public static String getSourcePositionPackageDisplayName(DebugProcessImpl debugProcess, @Nullable SourcePosition position) {
        String className;
        int dotIndex;
        List<ReferenceType> allClasses;
        String name2;
        String qName;
        PsiClass toplevel;
        if (position == null) {
            return null;
        }
        PsiFile positionFile = position.getFile();
        if (positionFile instanceof JspFile) {
            PsiDirectory dir = positionFile.getContainingDirectory();
            return dir != null ? dir.getVirtualFile().getPresentableUrl() : null;
        }
        PsiClass psiClass = JVMNameUtil.getClassAt(position);
        if (psiClass != null && (toplevel = PsiUtil.getTopLevelClass((PsiElement)psiClass)) != null && (qName = toplevel.getQualifiedName()) != null) {
            int i = qName.lastIndexOf(46);
            return i > 0 ? qName.substring(0, i) : "";
        }
        if (positionFile instanceof PsiClassOwner && !StringUtil.isEmpty((String)(name2 = ((PsiClassOwner)positionFile).getPackageName()))) {
            return name2;
        }
        if (debugProcess != null && debugProcess.isAttached() && !(allClasses = debugProcess.getPositionManager().getAllClasses(position)).isEmpty() && (dotIndex = (className = allClasses.get(0).name()).lastIndexOf(46)) >= 0) {
            return className.substring(0, dotIndex);
        }
        return "";
    }

    public static PsiClass getTopLevelParentClass(PsiClass psiClass) {
        return (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
    }

    @Nullable
    public static String getClassVMName(@Nullable PsiClass containingClass) {
        if (containingClass == null) {
            return null;
        }
        if (containingClass instanceof PsiAnonymousClass) {
            String parentName = JVMNameUtil.getClassVMName((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class));
            if (parentName == null) {
                return null;
            }
            return parentName + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)((PsiAnonymousClass)containingClass));
        }
        return JVMNameUtil.getNonAnonymousClassName(containingClass);
    }

    private static class JVMClassAt
    implements JVMName {
        private final SourcePosition mySourcePosition;

        JVMClassAt(SourcePosition sourcePosition) {
            this.mySourcePosition = sourcePosition;
        }

        @Override
        public String getName(DebugProcessImpl process2) throws EvaluateException {
            List<ReferenceType> allClasses = process2.getPositionManager().getAllClasses(this.mySourcePosition);
            if (allClasses.size() > 1) {
                String name2 = (String)ReadAction.compute(() -> JVMNameUtil.getClassVMName(JVMNameUtil.getClassAt(this.mySourcePosition)));
                for (ReferenceType aClass : allClasses) {
                    if (!Comparing.equal((String)aClass.name(), (String)name2)) continue;
                    return name2;
                }
            }
            if (!allClasses.isEmpty()) {
                return allClasses.get(0).name();
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{this.getDisplayName(process2)}));
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcess) {
            return (String)ReadAction.compute(() -> JVMNameUtil.getSourcePositionClassDisplayName(debugProcess, this.mySourcePosition));
        }
    }

    private static class JVMRawText
    implements JVMName {
        private String myText;

        JVMRawText(String text) {
            this.myText = text;
        }

        @Override
        public String getName(DebugProcessImpl process2) throws EvaluateException {
            return this.myText;
        }

        @Override
        public String getDisplayName(DebugProcessImpl debugProcess) {
            return this.myText;
        }

        public String getName() {
            return this.myText;
        }

        public void setName(String name2) {
            this.myText = name2;
        }

        public String toString() {
            return this.myText;
        }
    }

    private static class JVMNameBuffer {
        private final List<JVMName> myList = new ArrayList<JVMName>();

        private JVMNameBuffer() {
        }

        public void append(@NotNull JVMName evaluator) {
            this.myList.add(evaluator);
        }

        public void append(char name2) {
            this.append(Character.toString(name2));
        }

        public void append(String text) {
            this.myList.add(JVMNameUtil.getJVMRawText(text));
        }

        public JVMName toName() {
            final ArrayList<JVMName> optimised = new ArrayList<JVMName>();
            for (JVMName evaluator : this.myList) {
                if (evaluator instanceof JVMRawText && !optimised.isEmpty() && optimised.get(optimised.size() - 1) instanceof JVMRawText) {
                    JVMRawText nameEvaluator = (JVMRawText)optimised.get(optimised.size() - 1);
                    nameEvaluator.setName(nameEvaluator.getName() + ((JVMRawText)evaluator).getName());
                    continue;
                }
                optimised.add(evaluator);
            }
            if (optimised.size() == 1) {
                return (JVMName)optimised.get(0);
            }
            if (optimised.isEmpty()) {
                return new JVMRawText("");
            }
            return new JVMName(){
                String myName = null;

                @Override
                public String getName(DebugProcessImpl process2) throws EvaluateException {
                    if (this.myName == null) {
                        String name2 = "";
                        for (JVMName nameEvaluator : optimised) {
                            name2 = name2 + nameEvaluator.getName(process2);
                        }
                        this.myName = name2;
                    }
                    return this.myName;
                }

                @Override
                public String getDisplayName(DebugProcessImpl debugProcess) {
                    if (this.myName == null) {
                        String displayName2 = "";
                        for (JVMName nameEvaluator : optimised) {
                            displayName2 = displayName2 + nameEvaluator.getDisplayName(debugProcess);
                        }
                        return displayName2;
                    }
                    return this.myName;
                }
            };
        }
    }
}

