/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JavaReferringObjectsValue;
import com.intellij.debugger.actions.JumpToObjectAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.FullValueEvaluatorProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValuePresentation;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentReferringObjectsProvider;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XReferrersProvider;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XValueWithInlinePresentation;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class JavaValue
extends XNamedValue
implements NodeDescriptorProvider,
XValueTextProvider,
XValueWithInlinePresentation {
    private static final Logger LOG = Logger.getInstance(JavaValue.class);
    private final JavaValue myParent;
    private final ValueDescriptorImpl myValueDescriptor;
    private final EvaluationContextImpl myEvaluationContext;
    private final NodeManagerImpl myNodeManager;
    private final boolean myContextSet;
    private int myChildrenRemaining = -1;
    private volatile XExpression evaluationExpression = null;

    protected JavaValue(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        this(parent, valueDescriptor.calcValueName(), valueDescriptor, evaluationContext, nodeManager, contextSet);
    }

    protected JavaValue(JavaValue parent, String name2, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        super(name2);
        this.myParent = parent;
        this.myValueDescriptor = valueDescriptor;
        this.myEvaluationContext = evaluationContext;
        this.myNodeManager = nodeManager;
        this.myContextSet = contextSet;
    }

    public static JavaValue create(JavaValue parent, @NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager, boolean contextSet) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new JavaValue(parent, valueDescriptor, evaluationContext, nodeManager, contextSet);
    }

    static JavaValue create(@NotNull ValueDescriptorImpl valueDescriptor, @NotNull EvaluationContextImpl evaluationContext, NodeManagerImpl nodeManager) {
        return JavaValue.create(null, valueDescriptor, evaluationContext, nodeManager, false);
    }

    public JavaValue getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public ValueDescriptorImpl getDescriptor() {
        return this.myValueDescriptor;
    }

    @NotNull
    public EvaluationContextImpl getEvaluationContext() {
        return this.myEvaluationContext;
    }

    public NodeManagerImpl getNodeManager() {
        return this.myNodeManager;
    }

    private boolean isOnDemand() {
        return OnDemandRenderer.ON_DEMAND_CALCULATED.isIn((UserDataHolder)this.myValueDescriptor);
    }

    private boolean isCalculated() {
        return OnDemandRenderer.isCalculated(this.myValueDescriptor);
    }

    public void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        if (this.isOnDemand() && !this.isCalculated()) {
            node.setFullValueEvaluator(OnDemandRenderer.createFullValueEvaluator(DebuggerBundle.message((String)"message.node.evaluate", (Object[])new Object[0])));
            node.setPresentation(AllIcons.Debugger.Db_watch, (XValuePresentation)new XRegularValuePresentation("", null, ""), false);
            return;
        }
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                node.setPresentation(null, (XValuePresentation)new XErrorValuePresentation(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0])), false);
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                if (node.isObsolete()) {
                    return;
                }
                if (!JavaValue.this.myContextSet) {
                    JavaValue.this.myValueDescriptor.setContext(JavaValue.this.myEvaluationContext);
                }
                JavaValue.this.myValueDescriptor.updateRepresentation(JavaValue.this.myEvaluationContext, new DescriptorLabelListener(){

                    @Override
                    public void labelChanged() {
                        Icon nodeIcon = DebuggerTreeRenderer.getValueIcon(JavaValue.this.myValueDescriptor, JavaValue.this.myParent != null ? JavaValue.this.myParent.getDescriptor() : null);
                        XValuePresentation presentation = JavaValue.createPresentation(JavaValue.this.myValueDescriptor);
                        Renderer lastRenderer = JavaValue.this.myValueDescriptor.getLastRenderer();
                        boolean fullEvaluatorSet = this.setFullValueEvaluator(lastRenderer);
                        if (!fullEvaluatorSet && lastRenderer instanceof CompoundNodeRenderer) {
                            fullEvaluatorSet = this.setFullValueEvaluator(((CompoundNodeRenderer)lastRenderer).getLabelRenderer());
                        }
                        if (!fullEvaluatorSet && JavaValue.this.getValueText().length() > 1000) {
                            node.setFullValueEvaluator((XFullValueEvaluator)new JavaFullValueEvaluator(JavaValue.this.myEvaluationContext){

                                @Override
                                public void evaluate(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                    final ValueDescriptorImpl fullValueDescriptor = JavaValue.this.myValueDescriptor.getFullValueDescriptor();
                                    fullValueDescriptor.updateRepresentation(this.myEvaluationContext, new DescriptorLabelListener(){

                                        @Override
                                        public void labelChanged() {
                                            callback.evaluated(fullValueDescriptor.getValueText());
                                        }
                                    });
                                }
                            });
                        }
                        node.setPresentation(nodeIcon, presentation, JavaValue.this.myValueDescriptor.isExpandable());
                    }

                    private boolean setFullValueEvaluator(Renderer renderer) {
                        XFullValueEvaluator evaluator;
                        if (renderer instanceof FullValueEvaluatorProvider && (evaluator = ((FullValueEvaluatorProvider)((Object)renderer)).getFullValueEvaluator(JavaValue.this.myEvaluationContext, JavaValue.this.myValueDescriptor)) != null) {
                            node.setFullValueEvaluator(evaluator);
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
    }

    public static XValuePresentation createPresentation(ValueDescriptorImpl descriptor2) {
        Object presentation = null;
        Renderer lastLabelRenderer = descriptor2.getLastLabelRenderer();
        if (lastLabelRenderer instanceof ValueLabelRenderer) {
            presentation = ((ValueLabelRenderer)lastLabelRenderer).getPresentation(descriptor2);
        }
        if (presentation == null) {
            presentation = new JavaValuePresentation(descriptor2);
        }
        return presentation;
    }

    public void computeChildren(final @NotNull XCompositeNode node) {
        JavaValue.scheduleCommand(this.myEvaluationContext, node, new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                JavaValue.this.myValueDescriptor.getChildrenRenderer(JavaValue.this.myEvaluationContext.getDebugProcess()).buildChildren(JavaValue.this.myValueDescriptor.getValue(), new ChildrenBuilder(){

                    @Override
                    public NodeDescriptorFactory getDescriptorManager() {
                        return JavaValue.this.myNodeManager;
                    }

                    @Override
                    public NodeManager getNodeManager() {
                        return JavaValue.this.myNodeManager;
                    }

                    @Override
                    public ValueDescriptor getParentDescriptor() {
                        return JavaValue.this.myValueDescriptor;
                    }

                    @Override
                    public void initChildrenArrayRenderer(ArrayRenderer renderer, int arrayLength) {
                        renderer.START_INDEX = 0;
                        if (JavaValue.this.myChildrenRemaining >= 0) {
                            renderer.START_INDEX = Math.max(0, arrayLength - JavaValue.this.myChildrenRemaining);
                        }
                    }

                    @Override
                    public void addChildren(List<DebuggerTreeNode> nodes, boolean last) {
                        XValueChildrenList childrenList = XValueChildrenList.EMPTY;
                        if (!nodes.isEmpty()) {
                            childrenList = new XValueChildrenList(nodes.size());
                            for (DebuggerTreeNode treeNode : nodes) {
                                NodeDescriptor descriptor2 = treeNode.getDescriptor();
                                if (descriptor2 instanceof ValueDescriptorImpl) {
                                    childrenList.add((XNamedValue)JavaValue.create(JavaValue.this, (ValueDescriptorImpl)descriptor2, JavaValue.this.myEvaluationContext, JavaValue.this.myNodeManager, false));
                                    continue;
                                }
                                if (!(descriptor2 instanceof MessageDescriptor)) continue;
                                childrenList.add((XNamedValue)new JavaStackFrame.DummyMessageValueNode(descriptor2.getLabel(), DebuggerTreeRenderer.getDescriptorIcon(descriptor2)));
                            }
                        }
                        node.addChildren(childrenList, last);
                    }

                    @Override
                    public void setChildren(List<DebuggerTreeNode> nodes) {
                        this.addChildren(nodes, true);
                    }

                    public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
                        node.setMessage(message, icon, attributes, link);
                    }

                    public void addChildren(@NotNull XValueChildrenList children, boolean last) {
                        node.addChildren(children, last);
                    }

                    public void tooManyChildren(int remaining) {
                        JavaValue.this.myChildrenRemaining = remaining;
                        node.tooManyChildren(remaining);
                    }

                    public void setAlreadySorted(boolean alreadySorted) {
                        node.setAlreadySorted(alreadySorted);
                    }

                    public void setErrorMessage(@NotNull String errorMessage) {
                        node.setErrorMessage(errorMessage);
                    }

                    public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
                        node.setErrorMessage(errorMessage, link);
                    }

                    public boolean isObsolete() {
                        return node.isObsolete();
                    }
                }, JavaValue.this.myEvaluationContext);
            }
        });
    }

    protected static boolean scheduleCommand(EvaluationContextImpl evaluationContext, final @NotNull XCompositeNode node, final SuspendContextCommandImpl command) {
        if (node.isObsolete()) {
            return false;
        }
        evaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(command.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                if (node.isObsolete()) {
                    return;
                }
                command.contextAction(suspendContext);
            }

            @Override
            protected void commandCancelled() {
                node.setErrorMessage(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
            }
        });
        return true;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        this.computeSourcePosition(navigatable, false);
    }

    private void computeSourcePosition(final @NotNull XNavigatable navigatable, final boolean inline) {
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return inline ? PrioritizedTask.Priority.LOWEST : PrioritizedTask.Priority.NORMAL;
            }

            @Override
            protected void commandCancelled() {
                navigatable.setSourcePosition(null);
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    SourcePosition position = SourcePositionProvider.getSourcePosition(JavaValue.this.myValueDescriptor, JavaValue.this.getProject(), JavaValue.this.getDebuggerContext(), false);
                    if (position != null) {
                        navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(position));
                    }
                    if (inline && (position = SourcePositionProvider.getSourcePosition(JavaValue.this.myValueDescriptor, JavaValue.this.getProject(), JavaValue.this.getDebuggerContext(), true)) != null) {
                        navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(position));
                    }
                });
            }
        });
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        this.computeSourcePosition(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0), true);
        return ThreeState.YES;
    }

    private DebuggerContextImpl getDebuggerContext() {
        return this.myEvaluationContext.getDebugProcess().getDebuggerContext();
    }

    public Project getProject() {
        return this.myValueDescriptor.getProject();
    }

    public boolean canNavigateToTypeSource() {
        return true;
    }

    public void computeTypeSourcePosition(final @NotNull XNavigatable navigatable) {
        if (this.myEvaluationContext.getSuspendContext().isResumed()) {
            return;
        }
        DebugProcessImpl debugProcess = this.myEvaluationContext.getDebugProcess();
        debugProcess.getManagerThread().schedule(new JumpToObjectAction.NavigateCommand(this.getDebuggerContext(), this.myValueDescriptor, debugProcess, null){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void doAction(@Nullable SourcePosition sourcePosition) {
                if (sourcePosition != null) {
                    ApplicationManager.getApplication().runReadAction(() -> navigatable.setSourcePosition(DebuggerUtilsEx.toXSourcePosition(sourcePosition)));
                }
            }
        });
    }

    @Nullable
    public XValueModifier getModifier() {
        return this.myValueDescriptor.canSetValue() ? this.myValueDescriptor.getModifier(this) : null;
    }

    @NotNull
    public Promise<XExpression> calculateEvaluationExpression() {
        if (this.evaluationExpression != null) {
            return Promises.resolvedPromise((Object)this.evaluationExpression);
        }
        final AsyncPromise res = new AsyncPromise();
        this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                JavaValue.this.evaluationExpression = (XExpression)ReadAction.compute(() -> {
                    try {
                        PsiElement psiExpression = JavaValue.this.getDescriptor().getTreeEvaluation(JavaValue.this, JavaValue.this.getDebuggerContext());
                        if (psiExpression != null) {
                            XExpression res2 = TextWithImportsImpl.toXExpression(new TextWithImportsImpl(psiExpression));
                            Set imports = (Set)psiExpression.getUserData(DebuggerTreeNodeExpression.ADDITIONAL_IMPORTS_KEY);
                            if (imports != null && res2 != null) {
                                if (res2.getCustomInfo() != null) {
                                    imports.add(res2.getCustomInfo());
                                }
                                res2 = new XExpressionImpl(res2.getExpression(), res2.getLanguage(), StringUtil.join((Collection)imports, (String)","), res2.getMode());
                            }
                            return res2;
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.info((Throwable)e);
                    }
                    return null;
                });
                res.setResult((Object)JavaValue.this.evaluationExpression);
            }
        });
        return res;
    }

    @NotNull
    public String getValueText() {
        return this.myValueDescriptor.getValueText();
    }

    @Nullable
    public XReferrersProvider getReferrersProvider() {
        return new XReferrersProvider(){

            public XValue getReferringObjectsValue() {
                MemoryAgent memoryAgent = JavaValue.this.getEvaluationContext().getDebugProcess().getMemoryAgent();
                ReferringObjectsProvider provider2 = ReferringObjectsProvider.BASIC_JDI;
                if (memoryAgent != null && memoryAgent.canFindGcRoots()) {
                    provider2 = new MemoryAgentReferringObjectsProvider(memoryAgent, 1000);
                }
                return new JavaReferringObjectsValue(JavaValue.this, provider2, null);
            }
        };
    }

    @Nullable
    public XInstanceEvaluator getInstanceEvaluator() {
        return new XInstanceEvaluator(){

            public void evaluate(final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @NotNull XStackFrame frame) {
                JavaValue.this.myEvaluationContext.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void commandCancelled() {
                        callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                    }

                    @Override
                    protected void action() {
                        EvaluationContextImpl evaluationContext;
                        NodeDescriptor item;
                        Modifier modifier;
                        ValueDescriptorImpl inspectDescriptor = JavaValue.this.myValueDescriptor;
                        if (JavaValue.this.myValueDescriptor instanceof WatchItemDescriptor && (modifier = ((WatchItemDescriptor)JavaValue.this.myValueDescriptor).getModifier()) != null && (item = modifier.getInspectItem(JavaValue.this.getProject())) != null) {
                            inspectDescriptor = (ValueDescriptorImpl)item;
                        }
                        if ((evaluationContext = ((JavaStackFrame)frame).getFrameDebuggerContext(null).createEvaluationContext()) != null) {
                            callback.evaluated((XValue)JavaValue.create(inspectDescriptor, evaluationContext, JavaValue.this.myNodeManager));
                        } else {
                            callback.errorOccurred("Context is not available");
                        }
                    }
                });
            }
        };
    }

    public void setRenderer(NodeRenderer nodeRenderer, XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myValueDescriptor.setRenderer(nodeRenderer);
        this.reBuild(node);
    }

    public void reBuild(XValueNodeImpl node) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myChildrenRemaining = -1;
        node.invokeNodeUpdate(() -> {
            node.clearChildren();
            this.computePresentation((XValueNode)node, XValuePlace.TREE);
        });
    }

    @Nullable
    public String computeInlinePresentation() {
        ValueDescriptorImpl descriptor2 = this.getDescriptor();
        return descriptor2.isNull() || descriptor2.isPrimitive() ? descriptor2.getValueText() : null;
    }

    public static abstract class JavaFullValueEvaluator
    extends XFullValueEvaluator {
        protected final EvaluationContextImpl myEvaluationContext;

        public JavaFullValueEvaluator(@NotNull String linkText, EvaluationContextImpl evaluationContext) {
            super(linkText);
            this.myEvaluationContext = evaluationContext;
        }

        public JavaFullValueEvaluator(EvaluationContextImpl evaluationContext) {
            this.myEvaluationContext = evaluationContext;
        }

        public abstract void evaluate(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback var1) throws Exception;

        protected EvaluationContextImpl getEvaluationContext() {
            return this.myEvaluationContext;
        }

        public void startEvaluation(final @NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
            if (callback.isObsolete()) {
                return;
            }
            this.myEvaluationContext.getManagerThread().schedule(new SuspendContextCommandImpl(this.myEvaluationContext.getSuspendContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.NORMAL;
                }

                @Override
                protected void commandCancelled() {
                    callback.errorOccurred(DebuggerBundle.message((String)"error.context.has.changed", (Object[])new Object[0]));
                }

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                    if (callback.isObsolete()) {
                        return;
                    }
                    this.evaluate(callback);
                }
            });
        }
    }
}

