/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.evaluate.XValueCompactPresentation;
import com.intellij.xdebugger.impl.ui.tree.XValueExtendedPresentation;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaValuePresentation
extends XValueExtendedPresentation
implements XValueCompactPresentation {
    protected final ValueDescriptorImpl myValueDescriptor;

    public JavaValuePresentation(ValueDescriptorImpl valueDescriptor) {
        this.myValueDescriptor = valueDescriptor;
    }

    @Nullable
    public String getType() {
        return this.myValueDescriptor.getIdLabel();
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        this.renderValue(renderer, null);
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer, @Nullable XValueNodeImpl node) {
        boolean compact = node != null;
        String valueText = this.myValueDescriptor.getValueText();
        EvaluateException exception = this.myValueDescriptor.getEvaluateException();
        if (exception != null) {
            String errorMessage = exception.getMessage();
            if (valueText.endsWith(errorMessage)) {
                renderer.renderValue(valueText.substring(0, valueText.length() - errorMessage.length()));
            }
            renderer.renderError(errorMessage);
        } else {
            JavaValue container;
            if (compact && node.getValueContainer() instanceof JavaValue && (container = (JavaValue)node.getValueContainer()).getDescriptor().isArray()) {
                String typeName;
                ArrayReference value = (ArrayReference)container.getDescriptor().getValue();
                ArrayType type = (ArrayType)container.getDescriptor().getType();
                if (type != null && (TypeConversionUtil.isPrimitive((String)(typeName = type.componentTypeName())) || "java.lang.String".equals(typeName))) {
                    int size = value.length();
                    int max = Math.min(size, "java.lang.String".equals(typeName) ? 5 : 10);
                    List<Value> values = value.getValues(0, max);
                    ArrayList<String> vals = new ArrayList<String>(max);
                    for (int i = 0; i < values.size(); ++i) {
                        vals.add(StringUtil.first((String)values.get(i).toString(), (int)15, (boolean)true));
                    }
                    String more = "";
                    if (vals.size() < size) {
                        more = ", + " + (size - vals.size()) + " more";
                    }
                    renderer.renderValue("{" + StringUtil.join(vals, (String)", ") + more + "}");
                    return;
                }
            }
            if (this.myValueDescriptor.isString()) {
                renderer.renderStringValue(valueText, "\"", 1000);
                return;
            }
            String value = JavaValuePresentation.truncateToMaxLength(valueText);
            Renderer lastRenderer = this.myValueDescriptor.getLastLabelRenderer();
            if (lastRenderer instanceof ToStringRenderer) {
                if (!((ToStringRenderer)lastRenderer).isShowValue(this.myValueDescriptor, this.myValueDescriptor.getStoredEvaluationContext())) {
                    return;
                }
                value = StringUtil.wrapWithDoubleQuote((String)value);
            }
            renderer.renderValue(value);
        }
    }

    @NotNull
    public String getSeparator() {
        boolean emptyAfterSeparator = !this.myValueDescriptor.isShowIdLabel() && this.isValueEmpty();
        String declaredType = this.myValueDescriptor.getDeclaredTypeLabel();
        if (!StringUtil.isEmpty((String)declaredType)) {
            return emptyAfterSeparator ? declaredType : declaredType + " " + " = ";
        }
        return emptyAfterSeparator ? "" : " = ";
    }

    public boolean isModified() {
        return this.myValueDescriptor.isDirty();
    }

    private boolean isValueEmpty() {
        MyEmptyContainerChecker checker = new MyEmptyContainerChecker();
        this.renderValue((XValuePresentation.XValueTextRenderer)new XValueTextRendererImpl((ColoredTextContainer)checker));
        return checker.isEmpty;
    }

    private static String truncateToMaxLength(@NotNull String value) {
        return value.substring(0, Math.min(value.length(), 1000));
    }

    private static class MyEmptyContainerChecker
    implements ColoredTextContainer {
        boolean isEmpty = true;

        private MyEmptyContainerChecker() {
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
            if (!fragment.isEmpty()) {
                this.isEmpty = false;
            }
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag) {
            this.append(fragment, attributes);
        }

        public void setIcon(@Nullable Icon icon) {
        }

        public void setToolTipText(@Nullable String text) {
        }
    }
}

