/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.RemappedSourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionManagerImpl
implements PositionManager,
MultiRequestPositionManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcessImpl myDebugProcess;

    public PositionManagerImpl(DebugProcessImpl debugProcess) {
        this.myDebugProcess = debugProcess;
    }

    public DebugProcess getDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
        try {
            int line = position.getLine() + 1;
            return type.locationsOfLine("Java", null, line);
        }
        catch (AbsentInformationException absentInformationException) {
            return Collections.emptyList();
        }
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        throw new IllegalStateException("This class implements MultiRequestPositionManager, corresponding createPrepareRequests version should be used");
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
        return (List)ReadAction.compute(() -> {
            ArrayList<ClassPrepareRequest> res = new ArrayList<ClassPrepareRequest>();
            for (PsiClass psiClass : PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())) {
                ClassPrepareRequest request;
                ClassPrepareRequestor prepareRequestor = requestor;
                String classPattern = JVMNameUtil.getNonAnonymousClassName(psiClass);
                if (classPattern == null) {
                    String parentQName;
                    PsiClass parent = JVMNameUtil.getTopLevelParentClass(psiClass);
                    if (parent == null || (parentQName = JVMNameUtil.getNonAnonymousClassName(parent)) == null) continue;
                    classPattern = parentQName + "*";
                    prepareRequestor = new ClassPrepareRequestor(){

                        public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                            if (((DebugProcessImpl)debuggerProcess).getPositionManager().getAllClasses(position).contains(referenceType)) {
                                requestor.processClassPrepare(debuggerProcess, referenceType);
                            }
                        }
                    };
                }
                if ((request = this.myDebugProcess.getRequestsManager().createClassPrepareRequest(prepareRequestor, classPattern)) == null) continue;
                res.add(request);
            }
            return res;
        });
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        Set lambdas;
        PsiFile altPsiFile;
        VirtualFile altFile;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (location == null) {
            return null;
        }
        Project project2 = this.getDebugProcess().getProject();
        PsiFile psiFile = this.getPsiFileByLocation(project2, location);
        if (psiFile == null) {
            return null;
        }
        LOG.assertTrue(this.myDebugProcess != null);
        int lineNumber = DebuggerUtilsEx.getLineNumber(location, true);
        String qName = location.declaringType().name();
        String altFileUrl = DebuggerUtilsEx.getAlternativeSourceUrl(qName, project2);
        if (altFileUrl != null && (altFile = VirtualFileManager.getInstance().findFileByUrl(altFileUrl)) != null && (altPsiFile = psiFile.getManager().findFile(altFile)) != null) {
            psiFile = altPsiFile;
        }
        SourcePosition sourcePosition = null;
        if (lineNumber > -1) {
            sourcePosition = PositionManagerImpl.calcLineMappedSourcePosition(psiFile, lineNumber);
        }
        Method method = DebuggerUtilsEx.getMethod(location);
        if (sourcePosition == null && (psiFile instanceof PsiCompiledElement || lineNumber < 0)) {
            if (method != null && method.name() != null && method.signature() != null) {
                PsiClass psiClass = this.findPsiClassByName(qName, null);
                PsiMethod compiledMethod = this.findMethod((PsiElement)(psiClass != null ? psiClass : psiFile), qName, method.name(), method.signature());
                if (compiledMethod != null) {
                    sourcePosition = SourcePosition.createFromElement((PsiElement)compiledMethod);
                    if (lineNumber >= 0) {
                        sourcePosition = new ClsSourcePosition(sourcePosition, lineNumber);
                    }
                }
            } else {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)-1);
            }
        }
        if (sourcePosition == null) {
            sourcePosition = SourcePosition.createFromLine((PsiFile)psiFile, (int)lineNumber);
        }
        int lambdaOrdinal = -1;
        if (DebuggerUtilsEx.isLambda(method) && (lambdas = ContainerUtil.map2SetNotNull(this.locationsOfLine(location.declaringType(), sourcePosition), location1 -> {
            Method method1 = location1.method();
            if (DebuggerUtilsEx.isLambda(method1)) {
                return method1;
            }
            return null;
        })).size() > 1) {
            ArrayList<Method> lambdasList = new ArrayList<Method>(lambdas);
            lambdasList.sort(DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
            lambdaOrdinal = lambdasList.indexOf(method);
        }
        return new JavaSourcePosition(sourcePosition, location.declaringType(), method, lambdaOrdinal);
    }

    private static Set<PsiClass> getLineClasses(PsiFile file, int lineNumber) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        HashSet<PsiClass> res = new HashSet<PsiClass>();
        if (document2 != null) {
            XDebuggerUtil.getInstance().iterateLine(file.getProject(), document2, lineNumber, element -> {
                PsiClass aClass = PositionManagerImpl.getEnclosingClass(element);
                if (aClass != null) {
                    res.add(aClass);
                }
                return true;
            });
        }
        return res;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project2, Location location) {
        if (location == null) {
            return null;
        }
        ReferenceType refType = location.declaringType();
        if (refType == null) {
            return null;
        }
        String originalQName = refType.name();
        Ref altSource = new Ref();
        PsiClass psiClass = this.findPsiClassByName(originalQName, c -> altSource.set((Object)this.findAlternativeJreSourceFile((ClsClassImpl)c)));
        if (!altSource.isNull()) {
            return (PsiFile)altSource.get();
        }
        if (psiClass != null) {
            PsiElement fileElement;
            PsiElement element = psiClass.getNavigationElement();
            if (element instanceof PsiCompiledElement && !((fileElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement)) {
                element = fileElement;
            }
            return element.getContainingFile();
        }
        try {
            PsiFile[] files;
            for (PsiFile file : files = FilenameIndex.getFilesByName((Project)project2, (String)refType.sourceName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2))) {
                if (!(file instanceof PsiJavaFile)) continue;
                for (PsiClass cls : PsiTreeUtil.findChildrenOfAnyType((PsiElement)file, (Class[])new Class[]{PsiClass.class})) {
                    if (!StringUtil.equals((CharSequence)originalQName, (CharSequence)JVMNameUtil.getClassVMName(cls))) continue;
                    return file;
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    private PsiClass findPsiClassByName(String originalQName, @Nullable Consumer<ClsClassImpl> altClsProcessor) {
        PsiClass psiClass = null;
        Sdk alternativeJre = this.myDebugProcess.getSession().getAlternativeJre();
        if (alternativeJre != null && (psiClass = PositionManagerImpl.findClass(this.myDebugProcess.getProject(), originalQName, AlternativeJreClassFinder.getSearchScope(alternativeJre))) instanceof ClsClassImpl && altClsProcessor != null) {
            altClsProcessor.accept((ClsClassImpl)psiClass);
        }
        if (psiClass == null) {
            psiClass = PositionManagerImpl.findClass(this.myDebugProcess.getProject(), originalQName, this.myDebugProcess.getSearchScope());
        }
        return psiClass;
    }

    @Nullable
    public static PsiClass findClass(Project project2, String originalQName, GlobalSearchScope searchScope) {
        int dollar;
        PsiClass psiClass = DebuggerUtils.findClass((String)originalQName, (Project)project2, (GlobalSearchScope)searchScope);
        if (psiClass == null && (dollar = originalQName.indexOf(36)) > 0) {
            psiClass = DebuggerUtils.findClass((String)originalQName.substring(0, dollar), (Project)project2, (GlobalSearchScope)searchScope);
        }
        return psiClass;
    }

    @Nullable
    private PsiFile findAlternativeJreSourceFile(ClsClassImpl psiClass) {
        String sourceFileName = psiClass.getSourceFileName();
        String packageName = ((PsiClassOwner)psiClass.getContainingFile()).getPackageName();
        String relativePath = packageName.isEmpty() ? sourceFileName : packageName.replace('.', '/') + '/' + sourceFileName;
        Sdk alternativeJre = this.myDebugProcess.getSession().getAlternativeJre();
        if (alternativeJre != null) {
            for (VirtualFile file : AlternativeJreClassFinder.getSourceRoots(alternativeJre)) {
                PsiFile psiSource;
                VirtualFile source = file.findFileByRelativePath(relativePath);
                if (source == null || !source.isValid() || !((psiSource = psiClass.getManager().findFile(source)) instanceof PsiClassOwner)) continue;
                return psiSource;
            }
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        return (List)ReadAction.compute(() -> StreamEx.of(PositionManagerImpl.getLineClasses(position.getFile(), position.getLine())).flatMap(aClass -> this.getClassReferences((PsiClass)aClass, position)).toList());
    }

    private StreamEx<ReferenceType> getClassReferences(@NotNull PsiClass psiClass, SourcePosition position) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean isLocalOrAnonymous = false;
        int requiredDepth = 0;
        String className = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (className == null) {
            isLocalOrAnonymous = true;
            Pair<PsiClass, Integer> enclosing = PositionManagerImpl.getTopOrStaticEnclosingClass(psiClass);
            PsiClass topLevelClass = (PsiClass)enclosing.first;
            if (topLevelClass != null) {
                String parentClassName = JVMNameUtil.getNonAnonymousClassName(topLevelClass);
                if (parentClassName != null) {
                    requiredDepth = (Integer)enclosing.second;
                    className = parentClassName;
                }
            } else {
                StringBuilder sb = new StringBuilder();
                PsiTreeUtil.treeWalkUp((PsiElement)psiClass, null, (element, element2) -> {
                    sb.append('\n').append(element);
                    return true;
                });
                LOG.info("Local or anonymous class " + psiClass + " has no non-local parent, parents:" + sb);
            }
        }
        if (className == null) {
            return StreamEx.empty();
        }
        if (!isLocalOrAnonymous) {
            return StreamEx.of(this.myDebugProcess.getVirtualMachineProxy().classesByName(className)).map(outer -> this.mapClass((ReferenceType)outer));
        }
        int depth = requiredDepth;
        return StreamEx.of(this.myDebugProcess.getVirtualMachineProxy().classesByName(className)).map(outer -> this.findNested((ReferenceType)outer, 0, psiClass, depth, position)).nonNull();
    }

    protected ReferenceType mapClass(ReferenceType type) {
        return type;
    }

    private static Pair<PsiClass, Integer> getTopOrStaticEnclosingClass(PsiClass aClass) {
        int depth = 0;
        PsiClass enclosing = PositionManagerImpl.getEnclosingClass((PsiElement)aClass);
        while (enclosing != null) {
            PsiClass next;
            ++depth;
            if (enclosing.hasModifierProperty("static") || (next = PositionManagerImpl.getEnclosingClass((PsiElement)enclosing)) == null) break;
            enclosing = next;
        }
        return Pair.create((Object)enclosing, (Object)depth);
    }

    @Nullable
    private static PsiClass getEnclosingClass(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement previous = null;
        for (element = element.getParent(); element != null; element = element.getParent()) {
            if (element instanceof PsiClass && !(previous instanceof PsiExpressionList)) {
                return (PsiClass)element;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            previous = element;
        }
        return null;
    }

    @Nullable
    private ReferenceType findNested(ReferenceType fromClass, int currentDepth, PsiClass classToFind, int requiredDepth, SourcePosition position) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualMachineProxyImpl vmProxy = this.myDebugProcess.getVirtualMachineProxy();
        if (fromClass.isPrepared()) {
            int positionLine;
            if (currentDepth < requiredDepth) {
                List<ReferenceType> nestedTypes = vmProxy.nestedTypes(fromClass);
                for (ReferenceType nested : nestedTypes) {
                    ReferenceType found2 = this.findNested(nested, currentDepth + 1, classToFind, requiredDepth, position);
                    if (found2 == null) continue;
                    return found2;
                }
                return null;
            }
            int rangeBegin = Integer.MAX_VALUE;
            int rangeEnd = Integer.MIN_VALUE;
            ReferenceType mapped = this.mapClass(fromClass);
            List<Location> locations = DebuggerUtilsEx.allLineLocations(mapped);
            if (locations != null) {
                for (Location location : locations) {
                    Method method;
                    int lnumber = DebuggerUtilsEx.getLineNumber(location, false);
                    if (lnumber <= 1 || (method = DebuggerUtilsEx.getMethod(location)) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                    int locationLine = lnumber - 1;
                    PsiFile psiFile = position.getFile().getOriginalFile();
                    if (psiFile instanceof PsiCompiledFile && (locationLine = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, locationLine)) < 0) continue;
                    rangeBegin = Math.min(rangeBegin, locationLine);
                    rangeEnd = Math.max(rangeEnd, locationLine);
                }
            }
            if ((positionLine = position.getLine()) >= rangeBegin && positionLine <= rangeEnd) {
                if (!classToFind.isValid()) {
                    return null;
                }
                Set<PsiClass> lineClasses = PositionManagerImpl.getLineClasses(position.getFile(), rangeEnd);
                if (lineClasses.size() > 1) {
                    for (PsiClass aClass : lineClasses) {
                        if (!classToFind.equals(aClass)) continue;
                        return mapped;
                    }
                } else if (!lineClasses.isEmpty()) {
                    return classToFind.equals(lineClasses.iterator().next()) ? mapped : null;
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public PsiMethod findMethod(PsiElement container, String className, String methodName, String methodSignature) {
        MethodFinder finder = new MethodFinder(className, methodName, methodSignature);
        container.accept((PsiElementVisitor)finder);
        return finder.getCompiledMethod();
    }

    @Nullable
    private static SourcePosition calcLineMappedSourcePosition(PsiFile psiFile, int originalLine) {
        int line = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, originalLine);
        if (line > -1) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)line);
        }
        return null;
    }

    public static class ClsSourcePosition
    extends RemappedSourcePosition {
        private final int myOriginalLine;

        public ClsSourcePosition(SourcePosition delegate, int originalLine) {
            super(delegate);
            this.myOriginalLine = originalLine;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition original) {
            PsiFile file = this.getFile();
            if (this.myOriginalLine < 0 || !file.isValid()) {
                return original;
            }
            PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            SourcePosition position = PositionManagerImpl.calcLineMappedSourcePosition(file, this.myOriginalLine);
            return position != null ? position : original;
        }
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String myClassName;
        private PsiClass myCompiledClass;
        private final String myMethodName;
        private final String myMethodSignature;
        private PsiMethod myCompiledMethod;

        MethodFinder(String className, String methodName, String methodSignature) {
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodSignature = methodSignature;
        }

        public void visitClass(PsiClass aClass) {
            if (this.myCompiledMethod == null) {
                if (PositionManagerImpl.this.getClassReferences(aClass, SourcePosition.createFromElement((PsiElement)aClass)).anyMatch(referenceType -> referenceType.name().equals(this.myClassName))) {
                    this.myCompiledClass = aClass;
                }
                aClass.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitMethod(PsiMethod method) {
            if (this.myCompiledMethod == null) {
                try {
                    String methodName = JVMNameUtil.getJVMMethodName(method);
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass != null && containingClass.equals(this.myCompiledClass) && methodName.equals(this.myMethodName) && JVMNameUtil.getJVMSignature(method).getName(PositionManagerImpl.this.myDebugProcess).equals(this.myMethodSignature)) {
                        this.myCompiledMethod = method;
                    }
                }
                catch (EvaluateException e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        public void visitElement(PsiElement element) {
            if (this.myCompiledMethod == null) {
                super.visitElement(element);
            }
        }

        @Nullable
        public PsiMethod getCompiledMethod() {
            return this.myCompiledMethod;
        }
    }

    public static class JavaSourcePosition
    extends RemappedSourcePosition {
        private final String myExpectedClassName;
        private final String myExpectedMethodName;
        private final int myLambdaOrdinal;

        public JavaSourcePosition(@NotNull SourcePosition delegate, ReferenceType declaringType, Method method, int lambdaOrdinal) {
            super(delegate);
            this.myExpectedClassName = declaringType != null ? declaringType.name() : null;
            this.myExpectedMethodName = method != null ? method.name() : null;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        public JavaSourcePosition(@NotNull SourcePosition delegate, int lambdaOrdinal) {
            super(delegate);
            assert (lambdaOrdinal > -1);
            this.myExpectedClassName = null;
            this.myExpectedMethodName = "lambda$";
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        private PsiElement remapElement(PsiElement element) {
            String name2 = JVMNameUtil.getClassVMName(PositionManagerImpl.getEnclosingClass(element));
            if (name2 != null && !name2.equals(this.myExpectedClassName)) {
                return null;
            }
            PsiElement method = DebuggerUtilsEx.getContainingMethod(element);
            if (!StringUtil.isEmpty((String)this.myExpectedMethodName)) {
                if (method == null) {
                    return null;
                }
                if ((method instanceof PsiMethod && this.myExpectedMethodName.equals(((PsiMethod)method).getName()) || method instanceof PsiLambdaExpression && DebuggerUtilsEx.isLambdaName(this.myExpectedMethodName)) && JavaSourcePosition.insideBody(element, DebuggerUtilsEx.getBody(method))) {
                    return element;
                }
            }
            return null;
        }

        private static boolean insideBody(@NotNull PsiElement element, @Nullable PsiElement body) {
            if (!PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)false)) {
                return false;
            }
            if (body instanceof PsiCodeBlock) {
                return !element.equals(((PsiCodeBlock)body).getRBrace()) && !element.equals(((PsiCodeBlock)body).getLBrace());
            }
            return true;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition original) {
            return (SourcePosition)ReadAction.compute(() -> {
                PsiFile file = original.getFile();
                int line = original.getLine();
                Document document2 = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                if (document2 == null || line >= document2.getLineCount()) {
                    return original;
                }
                if (DebuggerUtilsEx.isLambdaName(this.myExpectedMethodName) && this.myLambdaOrdinal > -1) {
                    PsiElement firstElem;
                    List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(original, true);
                    if (this.myLambdaOrdinal < lambdas.size() && (firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambdas.get(this.myLambdaOrdinal), document2, line)) != null) {
                        return SourcePosition.createFromElement((PsiElement)firstElem);
                    }
                } else {
                    Ref res = Ref.create();
                    XDebuggerUtil.getInstance().iterateLine(file.getProject(), document2, line, elem -> {
                        PsiElement remappedElement = this.remapElement((PsiElement)elem);
                        if (remappedElement != null) {
                            if (remappedElement.getTextOffset() > original.getOffset()) {
                                res.set((Object)SourcePosition.createFromElement((PsiElement)remappedElement));
                            }
                            return false;
                        }
                        return true;
                    });
                    if (!res.isNull()) {
                        return (SourcePosition)res.get();
                    }
                }
                return original;
            });
        }
    }
}

