/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.DebuggerComputableValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EvaluationContextImpl
implements EvaluationContext {
    private static final Logger LOG = Logger.getInstance(EvaluationContextImpl.class);
    private final DebuggerComputableValue myThisObject;
    private final SuspendContextImpl mySuspendContext;
    private final StackFrameProxyImpl myFrameProxy;
    private boolean myAutoLoadClasses = true;
    private ClassLoaderReference myClassLoader;

    private EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @NotNull DebuggerComputableValue thisObjectComputableValue) {
        this.myThisObject = thisObjectComputableValue;
        this.myFrameProxy = frameProxy;
        this.mySuspendContext = suspendContext;
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @NotNull EvaluatingComputable<? extends Value> thisObjectFactory) {
        this(suspendContext, frameProxy, new DebuggerComputableValue(thisObjectFactory));
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy, @Nullable Value thisObject) {
        this(suspendContext, frameProxy, new DebuggerComputableValue(thisObject));
    }

    public EvaluationContextImpl(@NotNull SuspendContextImpl suspendContext, @Nullable StackFrameProxyImpl frameProxy) {
        this(suspendContext, frameProxy, () -> frameProxy != null ? frameProxy.thisObject() : null);
    }

    @Deprecated
    @Nullable
    public Value getThisObject() {
        try {
            return this.computeThisObject();
        }
        catch (EvaluateException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    public Value computeThisObject() throws EvaluateException {
        return this.myThisObject.getValue();
    }

    @NotNull
    public SuspendContextImpl getSuspendContext() {
        return this.mySuspendContext;
    }

    public StackFrameProxyImpl getFrameProxy() {
        return this.myFrameProxy;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        return this.getSuspendContext().getDebugProcess();
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.getDebugProcess().getManagerThread();
    }

    public Project getProject() {
        DebugProcessImpl debugProcess = this.getDebugProcess();
        return debugProcess.getProject();
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        EvaluationContextImpl copy = new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
        copy.setAutoLoadClasses(this.myAutoLoadClasses);
        return copy;
    }

    @Nullable
    public ClassLoaderReference getClassLoader() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.myClassLoader != null) {
            return this.myClassLoader;
        }
        return this.myFrameProxy != null ? this.myFrameProxy.getClassLoader() : null;
    }

    public void setClassLoader(ClassLoaderReference classLoader) {
        this.myClassLoader = classLoader;
    }

    public boolean isAutoLoadClasses() {
        return this.myAutoLoadClasses;
    }

    public void setAutoLoadClasses(boolean autoLoadClasses) {
        this.myAutoLoadClasses = autoLoadClasses;
    }

    public EvaluationContextImpl withAutoLoadClasses(boolean autoLoadClasses) {
        if (this.myAutoLoadClasses == autoLoadClasses) {
            return this;
        }
        EvaluationContextImpl copy = new EvaluationContextImpl(this.mySuspendContext, this.myFrameProxy, this.myThisObject);
        copy.setAutoLoadClasses(autoLoadClasses);
        return copy;
    }

    public void keep(Value value) {
        if (value instanceof ObjectReference) {
            this.getSuspendContext().keep((ObjectReference)value);
        }
    }

    public <T extends Value> T computeAndKeep(@NotNull ThrowableComputable<T, EvaluateException> computable) throws EvaluateException {
        int retries = 10;
        while (true) {
            Value res = (Value)computable.compute();
            try {
                this.keep(res);
                return (T)res;
            }
            catch (ObjectCollectedException oce) {
                if (--retries >= 0) continue;
                throw oce;
            }
            break;
        }
    }

    public boolean isEvaluationPossible() {
        return this.getSuspendContext().getDebugProcess().isEvaluationPossible(this.getSuspendContext());
    }
}

