/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextWithImportsImpl
implements TextWithImports {
    private final CodeFragmentKind myKind;
    private String myText;
    private final FileType myFileType;
    private final String myImports;
    private static final char SEPARATOR = '\r';

    public TextWithImportsImpl(@NotNull PsiElement expression) {
        this.myKind = CodeFragmentKind.EXPRESSION;
        String text = expression.getText();
        PsiFile containingFile = expression.getContainingFile();
        if (containingFile instanceof PsiExpressionCodeFragment) {
            this.myText = text;
            this.myImports = ((JavaCodeFragment)containingFile).importsToString();
            this.myFileType = StdFileTypes.JAVA;
        } else {
            Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
            this.myText = (String)trinity.first;
            this.myImports = (String)trinity.second;
            this.myFileType = (FileType)trinity.third;
        }
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text, @NotNull String imports, @Nullable FileType fileType) {
        this.myKind = kind;
        this.myText = text;
        this.myImports = imports;
        this.myFileType = fileType;
    }

    public TextWithImportsImpl(CodeFragmentKind kind, @NotNull String text) {
        this.myKind = kind;
        Trinity<String, String, FileType> trinity = TextWithImportsImpl.parseExternalForm(text);
        this.myText = (String)trinity.first;
        this.myImports = (String)trinity.second;
        this.myFileType = (FileType)trinity.third;
    }

    private static Trinity<String, String, FileType> parseExternalForm(String s) {
        String[] split = s.split(String.valueOf('\r'));
        return Trinity.create((Object)split[0], (Object)(split.length > 1 ? split[1] : ""), split.length > 2 ? FileTypeManager.getInstance().getStdFileType(split[2]) : null);
    }

    public CodeFragmentKind getKind() {
        return this.myKind;
    }

    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getImports() {
        return this.myImports;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextWithImportsImpl)) {
            return false;
        }
        TextWithImportsImpl item = (TextWithImportsImpl)object;
        return Comparing.equal((String)item.myText, (String)this.myText) && Comparing.equal((String)item.myImports, (String)this.myImports);
    }

    public String toString() {
        return this.getText();
    }

    public String toExternalForm() {
        String result = this.myText;
        if (StringUtil.isNotEmpty((String)this.myImports) || this.myFileType != null) {
            result = result + '\r' + this.myImports;
        }
        if (this.myFileType != null) {
            result = result + '\r' + this.myFileType.getName();
        }
        return result;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isEmpty() {
        return StringUtil.isEmptyOrSpaces((String)this.getText());
    }

    public void setText(String newText) {
        this.myText = newText;
    }

    public FileType getFileType() {
        return this.myFileType;
    }

    @Nullable
    public static XExpression toXExpression(@Nullable TextWithImports text) {
        if (text != null && !text.getText().isEmpty()) {
            return new XExpressionImpl(text.getText(), LanguageUtil.getFileTypeLanguage((FileType)text.getFileType()), StringUtil.nullize((String)text.getImports()), TextWithImportsImpl.getMode(text.getKind()));
        }
        return null;
    }

    @NotNull
    private static EvaluationMode getMode(@NotNull CodeFragmentKind kind) {
        switch (kind) {
            case EXPRESSION: {
                return EvaluationMode.EXPRESSION;
            }
            case CODE_BLOCK: {
                return EvaluationMode.CODE_FRAGMENT;
            }
        }
        throw new IllegalStateException("Unknown kind " + kind);
    }

    @NotNull
    private static CodeFragmentKind getKind(@NotNull EvaluationMode mode) {
        switch (mode) {
            case EXPRESSION: {
                return CodeFragmentKind.EXPRESSION;
            }
            case CODE_FRAGMENT: {
                return CodeFragmentKind.CODE_BLOCK;
            }
        }
        throw new IllegalStateException("Unknown mode " + mode);
    }

    public static TextWithImports fromXExpression(@Nullable XExpression expression) {
        if (expression == null) {
            return null;
        }
        if (expression.getCustomInfo() == null && expression.getLanguage() == null) {
            return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression.getMode()), expression.getExpression());
        }
        return new TextWithImportsImpl(TextWithImportsImpl.getKind(expression.getMode()), expression.getExpression(), StringUtil.notNullize((String)expression.getCustomInfo()), LanguageUtil.getLanguageFileType((Language)expression.getLanguage()));
    }
}

