/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.configurations.ConfigurationWithAlternativeJre;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.NonClasspathDirectoriesScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeJreClassFinder
extends NonClasspathClassFinder {
    public AlternativeJreClassFinder(Project project2, DebuggerManagerEx manager) {
        super(project2, new String[0]);
        manager.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession session) {
                AlternativeJreClassFinder.this.clearCache();
            }

            @Override
            public void sessionRemoved(DebuggerSession session) {
                AlternativeJreClassFinder.this.clearCache();
            }
        });
    }

    protected List<VirtualFile> calcClassRoots() {
        Collection<DebuggerSession> sessions = DebuggerManagerEx.getInstanceEx(this.myProject).getSessions();
        if (sessions.isEmpty()) {
            return Collections.emptyList();
        }
        List res = ContainerUtil.newSmartList();
        for (DebuggerSession session : sessions) {
            Sdk jre = session.getAlternativeJre();
            if (jre == null) continue;
            res.addAll(AlternativeJreClassFinder.getClassRoots(jre));
        }
        return res;
    }

    @Nullable
    public static Sdk getAlternativeJre(RunProfile profile2) {
        ConfigurationWithAlternativeJre appConfig;
        if (profile2 instanceof ConfigurationWithAlternativeJre && (appConfig = (ConfigurationWithAlternativeJre)profile2).isAlternativeJrePathEnabled()) {
            String path = appConfig.getAlternativeJrePath();
            return path == null ? null : ProjectJdkTable.getInstance().findJdk(path);
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getClassRoots(@NotNull Sdk jre) {
        return Arrays.asList(jre.getRootProvider().getFiles(OrderRootType.CLASSES));
    }

    @NotNull
    public static Collection<VirtualFile> getSourceRoots(@NotNull Sdk jre) {
        return Arrays.asList(jre.getRootProvider().getFiles(OrderRootType.SOURCES));
    }

    @NotNull
    public static GlobalSearchScope getSearchScope(@NotNull Sdk jre) {
        return new NonClasspathDirectoriesScope(AlternativeJreClassFinder.getClassRoots(jre));
    }
}

