/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.NameMapper;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.RemoteDebugProcessHandler;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.GenericDebuggerRunnerSettings;
import com.intellij.debugger.impl.RemoteConnectionBuilder;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DebuggerManagerImpl
extends DebuggerManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerManagerImpl");
    public static final String LOCALHOST_ADDRESS_FALLBACK = "127.0.0.1";
    private final Project myProject;
    private final HashMap<ProcessHandler, DebuggerSession> mySessions = new HashMap();
    private final BreakpointManager myBreakpointManager;
    private final List<NameMapper> myNameMappers = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Function<DebugProcess, PositionManager>> myCustomPositionManagerFactories = new SmartList();
    private final EventDispatcher<DebuggerManagerListener> myDispatcher = EventDispatcher.create(DebuggerManagerListener.class);
    private final MyDebuggerStateManager myDebuggerStateManager = new MyDebuggerStateManager();
    private final DebuggerContextListener mySessionListener = new DebuggerContextListener(){

        @Override
        public void changeEvent(@NotNull DebuggerContextImpl newContext, DebuggerSession.Event event) {
            DebuggerSession session = newContext.getDebuggerSession();
            if (event == DebuggerSession.Event.PAUSE && DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession != session) {
                DebuggerManagerImpl.this.myDebuggerStateManager.setState(newContext, session != null ? session.getState() : DebuggerSession.State.DISPOSED, event, null);
                return;
            }
            if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session) {
                DebuggerManagerImpl.this.myDebuggerStateManager.fireStateChanged(newContext, event);
            }
            if (event == DebuggerSession.Event.ATTACHED) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.myDispatcher.getMulticaster()).sessionAttached(session);
            } else if (event == DebuggerSession.Event.DETACHED) {
                ((DebuggerManagerListener)DebuggerManagerImpl.this.myDispatcher.getMulticaster()).sessionDetached(session);
            } else if (event == DebuggerSession.Event.DISPOSE) {
                DebuggerManagerImpl.this.dispose(session);
                if (DebuggerManagerImpl.this.myDebuggerStateManager.myDebuggerSession == session) {
                    DebuggerManagerImpl.this.myDebuggerStateManager.setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.DISPOSE, null);
                }
            }
        }
    };

    public void addClassNameMapper(NameMapper mapper) {
        this.myNameMappers.add(mapper);
    }

    public void removeClassNameMapper(NameMapper mapper) {
        this.myNameMappers.remove(mapper);
    }

    public String getVMClassQualifiedName(@NotNull PsiClass aClass) {
        for (NameMapper nameMapper : this.myNameMappers) {
            String qName = nameMapper.getQualifiedName(aClass);
            if (qName == null) continue;
            return qName;
        }
        return aClass.getQualifiedName();
    }

    @Override
    public void addDebuggerManagerListener(DebuggerManagerListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeDebuggerManagerListener(DebuggerManagerListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public DebuggerManagerImpl(@NotNull Project project2) {
        this.myProject = project2;
        this.myBreakpointManager = new BreakpointManager(this.myProject, this);
        MessageBusConnection busConnection = project2.getMessageBus().connect();
        if (!project2.isDefault()) {
            busConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

                public void globalSchemeChange(EditorColorsScheme scheme) {
                    DebuggerManagerImpl.this.getBreakpointManager().updateBreakpointsUI();
                }
            });
        }
        this.myBreakpointManager.addListeners(busConnection);
    }

    @Override
    @Nullable
    public DebuggerSession getSession(DebugProcess process2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getSessions().stream().filter(debuggerSession -> process2 == debuggerSession.getProcess()).findFirst().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Collection<DebuggerSession> getSessions() {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            Collection<DebuggerSession> values = this.mySessions.values();
            return values.isEmpty() ? Collections.emptyList() : new ArrayList<DebuggerSession>(values);
        }
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        this.myBreakpointManager.writeExternal(state);
        return state;
    }

    public void loadState(@NotNull Element state) {
        this.myBreakpointManager.readExternal(state);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myBreakpointManager.writeExternal(element);
    }

    @Deprecated
    public Stream<Function<DebugProcess, PositionManager>> getCustomPositionManagerFactories() {
        return this.myCustomPositionManagerFactories.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public DebuggerSession attachVirtualMachine(@NotNull DebugEnvironment environment) throws ExecutionException {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebugProcessEvents debugProcess = new DebugProcessEvents(this.myProject);
        DebuggerSession session = DebuggerSession.create(debugProcess, environment);
        ExecutionResult executionResult = session.getProcess().getExecutionResult();
        if (executionResult == null) {
            return null;
        }
        session.getContextManager().addListener(this.mySessionListener);
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(session, session.getContextManager().getContext().getSuspendContext()), session.getState(), DebuggerSession.Event.CONTEXT, null);
        ProcessHandler processHandler = executionResult.getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            this.mySessions.put(processHandler, session);
        }
        if (!(processHandler instanceof RemoteDebugProcessHandler)) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    ProcessHandler processHandler = event.getProcessHandler();
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.stop(willBeDestroyed && (!(processHandler instanceof KillableColoredProcessHandler) || !((KillableColoredProcessHandler)processHandler).shouldKillProcessSoftly()));
                        if (!DebuggerManagerThreadImpl.isManagerThread()) {
                            if (SwingUtilities.isEventDispatchThread()) {
                                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                                    debugProcess.waitFor(10000L);
                                }, "Waiting For Debugger Response", false, debugProcess.getProject());
                            } else {
                                debugProcess.waitFor(10000L);
                            }
                        }
                    }
                }
            });
        }
        ((DebuggerManagerListener)this.myDispatcher.getMulticaster()).sessionCreated(session);
        if (debugProcess.isDetached() || debugProcess.isDetaching()) {
            session.dispose();
            return null;
        }
        if (environment.isRemote()) {
            debugProcess.putUserData(BatchEvaluator.REMOTE_SESSION_KEY, Boolean.TRUE);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebugProcessImpl getDebugProcess(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            DebuggerSession session = this.mySessions.get(processHandler);
            return session != null ? session.getProcess() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DebuggerSession getDebugSession(ProcessHandler processHandler) {
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            return this.mySessions.get(processHandler);
        }
    }

    public void addDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler);
        if (debugProcess != null) {
            debugProcess.addDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.addDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            });
        }
    }

    public void removeDebugProcessListener(final ProcessHandler processHandler, final DebugProcessListener listener) {
        DebugProcessImpl debugProcess = this.getDebugProcess(processHandler);
        if (debugProcess != null) {
            debugProcess.removeDebugProcessListener(listener);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    DebugProcessImpl debugProcess = DebuggerManagerImpl.this.getDebugProcess(processHandler);
                    if (debugProcess != null) {
                        debugProcess.removeDebugProcessListener(listener);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                }
            });
        }
    }

    public boolean isDebuggerManagerThread() {
        return DebuggerManagerThreadImpl.isManagerThread();
    }

    @Override
    @NotNull
    public BreakpointManager getBreakpointManager() {
        return this.myBreakpointManager;
    }

    @Override
    @NotNull
    public DebuggerContextImpl getContext() {
        return this.getContextManager().getContext();
    }

    @Override
    @NotNull
    public DebuggerStateManager getContextManager() {
        return this.myDebuggerStateManager;
    }

    public void registerPositionManagerFactory(Function<DebugProcess, PositionManager> factory) {
        this.myCustomPositionManagerFactories.add(factory);
    }

    @Deprecated
    public static RemoteConnection createDebugParameters(JavaParameters parameters, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(parameters, debuggerInServerMode, transport, debugPort, checkValidity, true);
    }

    @Deprecated
    public static RemoteConnection createDebugParameters(JavaParameters parameters, boolean debuggerInServerMode, int transport, String debugPort, boolean checkValidity, boolean addAsyncDebuggerAgent) throws ExecutionException {
        return new RemoteConnectionBuilder(debuggerInServerMode, transport, debugPort).checkValidity(checkValidity).asyncAgent(addAsyncDebuggerAgent).memoryAgent(DebuggerSettings.getInstance().ENABLE_MEMORY_AGENT).create(parameters);
    }

    public static RemoteConnection createDebugParameters(JavaParameters parameters, GenericDebuggerRunnerSettings settings, boolean checkValidity) throws ExecutionException {
        return DebuggerManagerImpl.createDebugParameters(parameters, settings.LOCAL, settings.getTransport(), settings.getDebugPort(), checkValidity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose(DebuggerSession session) {
        ProcessHandler processHandler = session.getProcess().getProcessHandler();
        HashMap<ProcessHandler, DebuggerSession> hashMap = this.mySessions;
        synchronized (hashMap) {
            DebuggerSession removed = this.mySessions.remove(processHandler);
            LOG.assertTrue(removed != null);
            ((DebuggerManagerListener)this.myDispatcher.getMulticaster()).sessionRemoved(session);
        }
    }

    private static class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerSession myDebuggerSession;

        private MyDebuggerStateManager() {
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            return this.myDebuggerSession == null ? DebuggerContextImpl.EMPTY_CONTEXT : this.myDebuggerSession.getContextManager().getContext();
        }

        @Override
        public void setState(@NotNull DebuggerContextImpl context, DebuggerSession.State state, DebuggerSession.Event event, String description) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myDebuggerSession = context.getDebuggerSession();
            if (this.myDebuggerSession != null) {
                this.myDebuggerSession.getContextManager().setState(context, state, event, description);
            } else {
                this.fireStateChanged(context, event);
            }
        }
    }
}

