/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.net.NetUtils;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionState;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerUtilsImpl
extends DebuggerUtilsEx {
    public static final Key<PsiType> PSI_TYPE_KEY = Key.create((String)"PSI_TYPE_KEY");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsImpl");

    public PsiExpression substituteThis(PsiExpression expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue, StackFrameContext context) throws EvaluateException {
        return DebuggerTreeNodeExpression.substituteThis((PsiElement)expressionWithThis, howToEvaluateThis, howToEvaluateThisValue);
    }

    @Override
    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    @Override
    public DebuggerTreeNode getSelectedNode(DataContext context) {
        return DebuggerAction.getSelectedNode(context);
    }

    public DebuggerContextImpl getDebuggerContext(DataContext context) {
        return DebuggerAction.getDebuggerContext(context);
    }

    public Element writeTextWithImports(TextWithImports text) {
        Element element = new Element("TextWithImports");
        element.setAttribute("text", text.toExternalForm());
        element.setAttribute("type", text.getKind() == CodeFragmentKind.EXPRESSION ? "expression" : "code fragment");
        return element;
    }

    public TextWithImports readTextWithImports(Element element) {
        LOG.assertTrue("TextWithImports".equals(element.getName()));
        String text = element.getAttributeValue("text");
        if ("expression".equals(element.getAttributeValue("type"))) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text);
        }
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, text);
    }

    public void writeTextWithImports(Element root, String name2, TextWithImports value) {
        if (value.getKind() == CodeFragmentKind.EXPRESSION) {
            JDOMExternalizerUtil.writeField((Element)root, (String)name2, (String)value.toExternalForm());
        } else {
            Element element = JDOMExternalizerUtil.writeOption((Element)root, (String)name2);
            XExpression expression = TextWithImportsImpl.toXExpression(value);
            if (expression != null) {
                XmlSerializer.serializeInto((Object)new XExpressionState(expression), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
            }
        }
    }

    public TextWithImports readTextWithImports(Element root, String name2) {
        String s = JDOMExternalizerUtil.readField((Element)root, (String)name2);
        if (s != null) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, s);
        }
        Element option = JDOMExternalizerUtil.readOption((Element)root, (String)name2);
        if (option != null) {
            XExpressionState state = new XExpressionState();
            XmlSerializer.deserializeInto((Object)state, (Element)option);
            return TextWithImportsImpl.fromXExpression(state.toXExpression());
        }
        return null;
    }

    public TextWithImports createExpressionWithImports(String expression) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression);
    }

    public PsiElement getContextElement(StackFrameContext context) {
        return PositionUtil.getContextElement(context);
    }

    @NotNull
    public static Pair<PsiElement, PsiType> getPsiClassAndType(@Nullable String className, Project project2) {
        PsiClass contextClass = null;
        PsiPrimitiveType contextType = null;
        if (!StringUtil.isEmpty((String)className)) {
            PsiPrimitiveType primitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)className);
            if (primitiveType != null) {
                contextClass = JavaPsiFacade.getInstance((Project)project2).findClass(primitiveType.getBoxedTypeName(), GlobalSearchScope.allScope((Project)project2));
                contextType = primitiveType;
            } else {
                contextClass = DebuggerUtilsImpl.findClass((String)className, (Project)project2, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2));
                if (contextClass != null) {
                    contextClass = contextClass.getNavigationElement();
                }
                if (contextClass instanceof PsiCompiledElement) {
                    contextClass = ((PsiCompiledElement)contextClass).getMirror();
                }
                contextType = DebuggerUtilsImpl.getType((String)className, (Project)project2);
            }
            if (contextClass != null) {
                contextClass.putUserData(PSI_TYPE_KEY, (Object)contextType);
            }
        }
        return Pair.create(contextClass, contextType);
    }

    public PsiClass chooseClassDialog(String title, Project project2) {
        TreeClassChooser dialog = TreeClassChooserFactory.getInstance((Project)project2).createAllProjectScopeChooser(title);
        dialog.showDialog();
        return dialog.getSelected();
    }

    public String findAvailableDebugAddress(boolean useSockets) throws ExecutionException {
        if (useSockets) {
            int freePort;
            try {
                freePort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException(DebugProcessImpl.processError(e));
            }
            return Integer.toString(freePort);
        }
        ListeningConnector connector = (ListeningConnector)DebugProcessImpl.findConnector(false, true);
        try {
            return DebuggerUtilsImpl.tryShmemConnect(connector, "");
        }
        catch (Exception e) {
            int tryNum = 0;
            while (true) {
                try {
                    return DebuggerUtilsImpl.tryShmemConnect(connector, "javadebug_" + (int)(Math.random() * 1000.0));
                }
                catch (Exception ex) {
                    if (tryNum++ <= 10) continue;
                    throw new ExecutionException(DebugProcessImpl.processError(ex));
                }
                break;
            }
        }
    }

    private static String tryShmemConnect(ListeningConnector connector, String address) throws IOException, IllegalConnectorArgumentsException {
        Map<String, Connector.Argument> map2 = connector.defaultArguments();
        map2.get("name").setValue(address);
        address = connector.startListening(map2);
        connector.stopListening(map2);
        return address;
    }

    public static boolean isRemote(DebugProcess debugProcess) {
        return Boolean.TRUE.equals(debugProcess.getUserData(BatchEvaluator.REMOTE_SESSION_KEY));
    }

    public static <T, E extends Exception> T suppressExceptions(ThrowableComputable<? extends T, ? extends E> supplier, T defaultValue) throws E {
        return DebuggerUtilsImpl.suppressExceptions(supplier, defaultValue, true, null);
    }

    public static <T, E extends Exception> T suppressExceptions(ThrowableComputable<? extends T, ? extends E> supplier, T defaultValue, boolean ignorePCE, Class<E> rethrow) throws E {
        try {
            return (T)supplier.compute();
        }
        catch (ProcessCanceledException e) {
            if (!ignorePCE) {
                throw e;
            }
        }
        catch (ObjectCollectedException | VMDisconnectedException e) {
            throw e;
        }
        catch (InternalException e) {
            LOG.info((Throwable)e);
        }
        catch (AssertionError | Exception e) {
            if (rethrow != null && rethrow.isInstance(e)) {
                throw e;
            }
            LOG.error((Throwable)e);
        }
        return defaultValue;
    }

    public static <T> T runInReadActionWithWriteActionPriorityWithRetries(@NotNull Computable<T> action) {
        if (ApplicationManagerEx.getApplicationEx().holdsReadLock()) {
            return (T)action.compute();
        }
        Ref res = Ref.create();
        while (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> res.set(action.compute()))) {
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
        return (T)res.get();
    }

    public static String getConnectionDisplayName(RemoteConnection connection) {
        if (connection instanceof PidRemoteConnection) {
            return "pid " + ((PidRemoteConnection)connection).getPid();
        }
        String addressDisplayName = DebuggerBundle.getAddressDisplayName((RemoteConnection)connection);
        String transportName = DebuggerBundle.getTransportName((RemoteConnection)connection);
        return DebuggerBundle.message((String)"string.connection", (Object[])new Object[]{addressDisplayName, transportName});
    }

    public static boolean instanceOf(@Nullable ReferenceType type, @NotNull ReferenceType superType) {
        if (type == null) {
            return false;
        }
        if (superType.equals(type)) {
            return true;
        }
        return DebuggerUtilsImpl.supertypes(type).anyMatch(t -> DebuggerUtilsImpl.instanceOf(t, superType));
    }

    public static Stream<? extends ReferenceType> supertypes(ReferenceType type) {
        if (type instanceof InterfaceType) {
            return ((InterfaceType)type).superinterfaces().stream();
        }
        if (type instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)type).superclass()).prepend(((ClassType)type).interfaces());
        }
        return StreamEx.empty();
    }

    @Nullable
    public static byte[] readBytesArray(Value bytesArray) {
        if (bytesArray instanceof ArrayReference) {
            List<Value> values = ((ArrayReference)bytesArray).getValues();
            byte[] res = new byte[values.size()];
            int idx = 0;
            for (Value value : values) {
                if (value instanceof ByteValue) {
                    res[idx++] = ((ByteValue)value).value();
                    continue;
                }
                return null;
            }
            return res;
        }
        return null;
    }
}

