/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HotSwapManager {
    private final Map<DebuggerSession, Long> myTimeStamps = new HashMap<DebuggerSession, Long>();
    private static final String CLASS_EXTENSION = ".class";
    private final Project myProject;

    public HotSwapManager(Project project2, DebuggerManagerEx manager) {
        this.myProject = project2;
        manager.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession session) {
                HotSwapManager.this.myTimeStamps.put(session, System.currentTimeMillis());
            }

            @Override
            public void sessionRemoved(DebuggerSession session) {
                HotSwapManager.this.myTimeStamps.remove(session);
            }
        });
    }

    private long getTimeStamp(DebuggerSession session) {
        Long tStamp = this.myTimeStamps.get(session);
        return tStamp != null ? tStamp : 0L;
    }

    void setTimeStamp(DebuggerSession session, long tStamp) {
        this.myTimeStamps.put(session, tStamp);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(DebuggerSession session, HotSwapProgress progress) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long timeStamp = this.getTimeStamp(session);
        HashMap<String, HotSwapFile> modifiedClasses = new HashMap<String, HotSwapFile>();
        List outputPaths = (List)ReadAction.compute(() -> JBIterable.of((Object[])OrderEnumerator.orderEntries((Project)this.myProject).classes().getRoots()).filterMap(o -> o.isDirectory() && !o.getFileSystem().isReadOnly() ? o.getPath() : null).toList());
        for (String path : outputPaths) {
            String rootPath = FileUtil.toCanonicalPath((String)path);
            HotSwapManager.collectModifiedClasses(new File(path), rootPath, rootPath + "/", modifiedClasses, progress, timeStamp);
        }
        return modifiedClasses;
    }

    private static boolean collectModifiedClasses(File file, String filePath2, String rootPath, Map<String, HotSwapFile> container, HotSwapProgress progress, long timeStamp) {
        if (progress.isCancelled()) {
            return false;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (HotSwapManager.collectModifiedClasses(child, filePath2 + "/" + child.getName(), rootPath, container, progress, timeStamp)) continue;
                return false;
            }
        } else if ((SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)filePath2, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)filePath2, (String)CLASS_EXTENSION)) && file.lastModified() > timeStamp) {
            progress.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{filePath2}));
            String qualifiedName = filePath2.substring(rootPath.length(), filePath2.length() - CLASS_EXTENSION.length()).replace('/', '.');
            container.put(qualifiedName, new HotSwapFile(file));
        }
        return true;
    }

    public static HotSwapManager getInstance(Project project2) {
        return (HotSwapManager)project2.getComponent(HotSwapManager.class);
    }

    private void reloadClasses(DebuggerSession session, Map<String, HotSwapFile> classesToReload, HotSwapProgress progress) {
        long newSwapTime = System.currentTimeMillis();
        new ReloadClassesWorker(session, progress).reloadClasses(classesToReload);
        if (progress.isCancelled()) {
            session.setModifiedClassesScanRequired(true);
        } else {
            this.setTimeStamp(session, newSwapTime);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<? extends DebuggerSession> sessions, Map<String, Collection<String>> generatedPaths) {
        HashMap<DebuggerSession, Map<String, HotSwapFile>> result = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> sessionWithStamps = new ArrayList<Pair>();
        for (DebuggerSession debuggerSession : sessions) {
            sessionWithStamps.add(new Pair((Object)debuggerSession, (Object)HotSwapManager.getInstance(debuggerSession.getProject()).getTimeStamp(debuggerSession)));
        }
        for (Map.Entry entry : generatedPaths.entrySet()) {
            File root = new File((String)entry.getKey());
            for (String relativePath : (Collection)entry.getValue()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)relativePath, (CharSequence)CLASS_EXTENSION) : StringUtil.endsWithIgnoreCase((String)relativePath, (String)CLASS_EXTENSION))) continue;
                String qualifiedName = relativePath.substring(0, relativePath.length() - CLASS_EXTENSION.length()).replace('/', '.');
                HotSwapFile hotswapFile = new HotSwapFile(new File(root, relativePath));
                long fileStamp = hotswapFile.file.lastModified();
                for (Pair pair2 : sessionWithStamps) {
                    DebuggerSession session = (DebuggerSession)pair2.first;
                    if (fileStamp <= (Long)pair2.second) continue;
                    result.computeIfAbsent(session, k -> new HashMap()).put(qualifiedName, hotswapFile);
                }
            }
        }
        return result;
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(List<? extends DebuggerSession> sessions, final HotSwapProgress swapProgress) {
        final HashMap<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses = new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        MultiProcessCommand scanClassesCommand = new MultiProcessCommand();
        swapProgress.setCancelWorker(() -> scanClassesCommand.cancel());
        for (final DebuggerSession debuggerSession : sessions) {
            if (!debuggerSession.isAttached()) continue;
            scanClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    swapProgress.setDebuggerSession(debuggerSession);
                    Map<String, HotSwapFile> sessionClasses = HotSwapManager.getInstance(swapProgress.getProject()).scanForModifiedClasses(debuggerSession, swapProgress);
                    if (!sessionClasses.isEmpty()) {
                        modifiedClasses.put(debuggerSession, sessionClasses);
                    }
                }
            });
        }
        swapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        scanClassesCommand.run();
        if (swapProgress.isCancelled()) {
            for (DebuggerSession debuggerSession : sessions) {
                debuggerSession.setModifiedClassesScanRequired(true);
            }
            return new HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        }
        return modifiedClasses;
    }

    public static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> modifiedClasses, final HotSwapProgress reloadClassesProgress) {
        MultiProcessCommand reloadClassesCommand = new MultiProcessCommand();
        reloadClassesProgress.setCancelWorker(() -> reloadClassesCommand.cancel());
        for (final DebuggerSession debuggerSession : modifiedClasses.keySet()) {
            reloadClassesCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() {
                    reloadClassesProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(reloadClassesProgress.getProject()).reloadClasses(debuggerSession, (Map)modifiedClasses.get(debuggerSession), reloadClassesProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        reloadClassesProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        reloadClassesCommand.run();
        ActionsCollector.getInstance().record("Reload Classes", HotSwapManager.class);
    }
}

