/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerInlayUtil;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEditorLinePainter;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerInlayUtil {

    public static class Helper
    implements XDebuggerInlayUtil.Helper {
        private Editor currentEditor;
        private PsiMethod currentMethod;

        @Nullable
        private static Editor findEditor(@NotNull Project project2, @NotNull VirtualFile file) {
            FileEditor editor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file);
            return editor instanceof TextEditor ? ((TextEditor)editor).getEditor() : null;
        }

        private static void setupValuePlaceholders(@NotNull Editor editor, @NotNull PsiMethod method) {
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiJavaToken lBrace = body.getLBrace();
            PsiJavaToken rBrace = body.getRBrace();
            if (lBrace == null || rBrace == null) {
                return;
            }
            Document document2 = editor.getDocument();
            int startLine = document2.getLineNumber(lBrace.getTextOffset());
            int endLine = document2.getLineNumber(rBrace.getTextOffset());
            CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(editor);
            for (int i = startLine; i < endLine; ++i) {
                XDebuggerInlayUtil.createBlockInlay((Editor)editor, (int)document2.getLineStartOffset(i));
            }
            keeper.restoreOriginalLocation(true);
        }

        public synchronized void setupValuePlaceholders(@NotNull Project project2, @Nullable XSourcePosition currentPosition) {
            PsiMethod m;
            PsiFile psiFile;
            Editor e;
            Editor editor = null;
            PsiMethod method = null;
            if (currentPosition != null && (e = Helper.findEditor(project2, currentPosition.getFile())) != null && (psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(e.getDocument())) != null && (m = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)currentPosition.getOffset(), PsiMethod.class, (boolean)false)) != null) {
                editor = e;
                method = m;
            }
            if (editor != this.currentEditor || method != this.currentMethod) {
                if (this.currentEditor != null) {
                    CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(editor);
                    XDebuggerInlayUtil.clearBlockInlays((Editor)this.currentEditor);
                    keeper.restoreOriginalLocation(true);
                }
                if (editor != null) {
                    Helper.setupValuePlaceholders(editor, method);
                }
                this.currentEditor = editor;
                this.currentMethod = method;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean showValueInBlockInlay(@NotNull Project project2, @NotNull XValueNodeImpl node, @NotNull XSourcePosition position) {
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(position.getFile());
            if (psiFile == null) {
                return false;
            }
            int offset = position.getOffset();
            PsiMethod method = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, PsiMethod.class, (boolean)false);
            if (method == null) {
                return false;
            }
            Helper helper = this;
            synchronized (helper) {
                if (method != this.currentMethod) {
                    return false;
                }
            }
            SimpleColoredText text = XDebuggerEditorLinePainter.createPresentation((XValueNodeImpl)node);
            if (text == null) {
                return false;
            }
            String presentationText = text.toString();
            UIUtil.invokeLaterIfNeeded(() -> {
                Editor editor = Helper.findEditor(project2, position.getFile());
                Helper helper = this;
                synchronized (helper) {
                    if (editor == null || editor != this.currentEditor || method != this.currentMethod) {
                        return;
                    }
                }
                XDebuggerInlayUtil.addValueToBlockInlay((Editor)editor, (int)offset, (String)presentationText);
            });
            return true;
        }
    }
}

