/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class SourceCodeChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.SourceCodeChecker");

    private SourceCodeChecker() {
    }

    public static void checkSource(final DebuggerContextImpl debuggerContext) {
        if (!Registry.is((String)"debugger.check.source")) {
            return;
        }
        SuspendContextImpl suspendContext = debuggerContext.getSuspendContext();
        if (suspendContext == null) {
            return;
        }
        suspendContext.getDebugProcess().getManagerThread().schedule(new SuspendContextCommandImpl(suspendContext){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContext) {
                try {
                    StackFrameProxyImpl frameProxy = debuggerContext.getFrameProxy();
                    if (frameProxy == null) {
                        return;
                    }
                    Location location = frameProxy.location();
                    SourceCodeChecker.check(location, debuggerContext.getSourcePosition(), suspendContext.getDebugProcess().getProject());
                }
                catch (EvaluateException e) {
                    LOG.info((Throwable)e);
                }
            }
        });
    }

    private static ThreeState check(Location location, SourcePosition position, Project project2) {
        Method method = DebuggerUtilsEx.getMethod(location);
        if (method == null || method.isConstructor() || method.isSynthetic() || method.isBridge() || method.isStaticInitializer() || method.declaringType() instanceof ClassType && ((ClassType)method.declaringType()).isEnum() || DebuggerUtilsEx.isLambda(method)) {
            return ThreeState.UNSURE;
        }
        List<Location> locations = DebuggerUtilsEx.allLineLocations(method);
        if (ContainerUtil.isEmpty(locations)) {
            return ThreeState.UNSURE;
        }
        if (position != null) {
            return (ThreeState)ReadAction.compute(() -> {
                PsiFile psiFile = position.getFile();
                if (!psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return ThreeState.UNSURE;
                }
                Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
                if (document2 == null) {
                    return ThreeState.UNSURE;
                }
                boolean res = false;
                PsiElement psiMethod = DebuggerUtilsEx.getContainingMethod(position);
                if (psiMethod != null) {
                    PsiDocComment comment;
                    TextRange range = psiMethod.getTextRange();
                    if (psiMethod instanceof PsiDocCommentOwner && (comment = ((PsiDocCommentOwner)psiMethod).getDocComment()) != null) {
                        range = new TextRange(comment.getTextRange().getEndOffset() + 1, range.getEndOffset());
                    }
                    int startLine = document2.getLineNumber(range.getStartOffset()) + 1;
                    int endLine = document2.getLineNumber(range.getEndOffset()) + 1;
                    res = SourceCodeChecker.getLinesStream(locations, psiFile).allMatch(line -> line == 0 || startLine <= line && line <= endLine);
                    if (!res) {
                        LOG.debug("Source check failed: Method " + method.name() + ", source: " + ((NavigationItem)psiMethod).getName() + "\nLines: " + SourceCodeChecker.getLinesStream(locations, psiFile).joining((CharSequence)", ") + "\nExpected range: " + startLine + "-" + endLine);
                    }
                } else {
                    LOG.debug("Source check failed: method " + method.name() + " not found in sources");
                }
                if (!res) {
                    FileEditor editor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(position.getFile().getVirtualFile());
                    if (editor instanceof TextEditor) {
                        AppUIUtil.invokeOnEdt(() -> HintManager.getInstance().showErrorHint(((TextEditor)editor).getEditor(), DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0])));
                    } else {
                        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0]), NotificationType.WARNING).notify(project2);
                    }
                    return ThreeState.NO;
                }
                return ThreeState.YES;
            });
        }
        return ThreeState.YES;
    }

    private static IntStreamEx getLinesStream(List<Location> locations, PsiFile psiFile) {
        IntStreamEx stream = StreamEx.of(locations).mapToInt(Location::lineNumber);
        if (psiFile instanceof PsiCompiledFile) {
            stream = stream.map(line -> DebuggerUtilsEx.bytecodeToSourceLine(psiFile, line) + 1);
        }
        return stream.filter(line -> line > 0);
    }

    private static void checkAllClasses(DebuggerContextImpl debuggerContext) {
        DebugProcessImpl process2 = debuggerContext.getDebugProcess();
        VirtualMachine machine = process2.getVirtualMachineProxy().getVirtualMachine();
        PositionManagerImpl positionManager = new PositionManagerImpl(process2);
        List<ReferenceType> types = machine.allClasses();
        System.out.println("Checking " + types.size() + " classes");
        int i = 0;
        block2: for (ReferenceType type : types) {
            ++i;
            try {
                for (Location loc : type.allLineLocations()) {
                    SourcePosition position = (SourcePosition)ReadAction.compute(() -> {
                        try {
                            return positionManager.getSourcePosition(loc);
                        }
                        catch (NoDataException ignore) {
                            return null;
                        }
                    });
                    if (position == null) continue;
                    if (position.getFile() instanceof PsiCompiledFile) {
                        VirtualFile file = position.getFile().getVirtualFile();
                        if (file == null || file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY) == null) continue block2;
                        if (DebuggerUtilsEx.bytecodeToSourceLine(position.getFile(), loc.lineNumber()) == -1) continue;
                    }
                    if (SourceCodeChecker.check(loc, position, process2.getProject()) != ThreeState.NO) continue;
                    System.out.println("failed " + type);
                }
            }
            catch (AbsentInformationException absentInformationException) {}
        }
        System.out.println("Done checking");
    }
}

