/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.attach;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.attach.JavaAttachDebuggerProvider;
import com.intellij.debugger.impl.attach.PidRemoteConnection;
import com.intellij.openapi.project.Project;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.attach.VirtualMachineDescriptor;
import java.io.IOException;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class JavaDebuggerAttachUtil {
    public static boolean canAttach(int pid) {
        return JavaAttachDebuggerProvider.getProcessAttachInfo(String.valueOf(pid)) != null;
    }

    public static boolean attach(int pid, Project project2) {
        JavaAttachDebuggerProvider.LocalAttachInfo info = JavaAttachDebuggerProvider.getProcessAttachInfo(String.valueOf(pid));
        if (info != null) {
            JavaAttachDebuggerProvider.attach(info, project2);
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<String> getAttachedPids(@NotNull Project project2) {
        return StreamEx.of(DebuggerManagerEx.getInstanceEx(project2).getSessions()).map(s -> s.getDebugEnvironment().getRemoteConnection()).select(PidRemoteConnection.class).map(PidRemoteConnection::getPid).toSet();
    }

    @NotNull
    public static VirtualMachine attachVirtualMachine(String id) throws IOException, AttachNotSupportedException {
        if (VirtualMachine.list().stream().map(VirtualMachineDescriptor::id).noneMatch(id::equals)) {
            throw new AttachNotSupportedException("AttachProvider for the vm is not found");
        }
        return VirtualMachine.attach(id);
    }
}

