/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ReferenceType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface ClassesByNameProvider {
    public List<ReferenceType> get(@NotNull String var1);

    public static ClassesByNameProvider createCache(List<ReferenceType> allTypes) {
        return new Cache(allTypes);
    }

    public static final class Cache
    implements ClassesByNameProvider {
        private final MultiMap<String, ReferenceType> myCache = new MultiMap();

        public Cache(List<ReferenceType> classes) {
            classes.forEach(t -> this.myCache.putValue((Object)t.signature(), t));
        }

        @Override
        public List<ReferenceType> get(@NotNull String s) {
            String signature = VirtualMachineProxyImpl.JNITypeParserReflect.typeNameToSignature(s);
            if (signature != null) {
                return (List)this.myCache.get((Object)signature);
            }
            return Collections.emptyList();
        }
    }
}

