/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.ThreeState;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ObjectReferenceProxyImpl
extends JdiProxy {
    private final ObjectReference myObjectReference;
    private ReferenceType myReferenceType;
    private Type myType;
    private ThreeState myIsCollected = ThreeState.UNSURE;

    public ObjectReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxy, @NotNull ObjectReference objectReference) {
        super(virtualMachineProxy);
        this.myObjectReference = objectReference;
    }

    public ObjectReference getObjectReference() {
        this.checkValid();
        return this.myObjectReference;
    }

    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public ReferenceType referenceType() {
        this.checkValid();
        if (this.myReferenceType == null) {
            this.myReferenceType = this.getObjectReference().referenceType();
        }
        return this.myReferenceType;
    }

    public Type type() {
        this.checkValid();
        if (this.myType == null) {
            this.myType = this.getObjectReference().type();
        }
        return this.myType;
    }

    @NonNls
    public String toString() {
        ObjectReference objectReference = this.getObjectReference();
        String objRefString = objectReference != null ? objectReference.toString() : "[referenced object collected]";
        return "ObjectReferenceProxyImpl: " + objRefString + " " + super.toString();
    }

    public Map<Field, Value> getValues(List<? extends Field> list) {
        return this.getObjectReference().getValues(list);
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.getObjectReference().setValue(field, value);
    }

    public boolean isCollected() {
        this.checkValid();
        if (this.myIsCollected != ThreeState.YES) {
            try {
                this.myIsCollected = ThreeState.fromBoolean((boolean)VirtualMachineProxyImpl.isCollected(this.myObjectReference));
            }
            catch (VMDisconnectedException ignored) {
                this.myIsCollected = ThreeState.YES;
            }
        }
        return this.myIsCollected.toBoolean();
    }

    public long uniqueID() {
        return this.getObjectReference().uniqueID();
    }

    public List<ThreadReferenceProxyImpl> waitingThreads() throws IncompatibleThreadStateException {
        return StreamEx.of(this.getObjectReference().waitingThreads()).map(this.getVirtualMachineProxy()::getThreadReferenceProxy).toList();
    }

    public ThreadReferenceProxyImpl owningThread() throws IncompatibleThreadStateException {
        return this.getVirtualMachineProxy().getThreadReferenceProxy(this.getObjectReference().owningThread());
    }

    public int entryCount() throws IncompatibleThreadStateException {
        return this.getObjectReference().entryCount();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ObjectReferenceProxyImpl)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        return this.myObjectReference.equals(((ObjectReferenceProxyImpl)o).myObjectReference);
    }

    public int hashCode() {
        return this.myObjectReference.hashCode();
    }

    @Override
    protected void clearCaches() {
        if (this.myIsCollected == ThreeState.NO) {
            this.myIsCollected = ThreeState.UNSURE;
        }
    }
}

