/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public abstract class MemoryAgentActionBase
extends DebuggerTreeAction {
    protected final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());

    protected void perform(final XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        Project project2 = node.getTree().getProject();
        final DebugProcessImpl debugProcess = JavaDebugProcess.getCurrentDebugProcess(project2);
        final ObjectReference reference = this.getObjectReference(node);
        if (debugProcess == null || reference == null) {
            return;
        }
        debugProcess.getManagerThread().invokeCommand(new DebuggerCommand(){

            public void action() {
                MemoryAgent memoryAgent = debugProcess.getMemoryAgent();
                MemoryAgentActionBase.this.LOG.assertTrue(memoryAgent != null);
                try {
                    MemoryAgentActionBase.this.perform(memoryAgent, reference, node);
                }
                catch (EvaluateException ex) {
                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("Action failed", NotificationType.ERROR);
                }
            }

            public void commandCancelled() {
                MemoryAgentActionBase.this.LOG.info("command cancelled");
            }
        });
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        MemoryAgent memoryAgent;
        if (!super.isEnabled(node, e)) {
            return false;
        }
        DebugProcessImpl debugProcess = JavaDebugProcess.getCurrentDebugProcess(node.getTree().getProject());
        MemoryAgent memoryAgent2 = memoryAgent = debugProcess == null ? null : debugProcess.getMemoryAgent();
        if (memoryAgent == null || !memoryAgent.isLoaded()) {
            e.getPresentation().setVisible(false);
            return false;
        }
        ObjectReference reference = this.getObjectReference(node);
        return reference != null && this.isEnabled(memoryAgent);
    }

    protected abstract boolean isEnabled(@NotNull MemoryAgent var1);

    protected abstract void perform(@NotNull MemoryAgent var1, @NotNull ObjectReference var2, @NotNull XValueNodeImpl var3) throws EvaluateException;
}

