/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.extractor.ProxyExtractor;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentLoader {
    public static final MemoryAgent DEFAULT_PROXY = new MyDisabledMemoryAgent();
    private static final Logger LOG = Logger.getInstance(AgentLoader.class);

    @NotNull
    public MemoryAgent load(@NotNull EvaluationContextImpl evaluationContext, @NotNull VirtualMachineProxy virtualMachine) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            ClassType classType = AgentLoader.ensureClassLoaded(evaluationContext, virtualMachine);
            if (classType != null) {
                MemoryAgentImpl agent = new MemoryAgentImpl(evaluationContext.getDebugProcess(), classType);
                agent.initializeCapabilities();
                return agent.isLoaded() ? agent : DEFAULT_PROXY;
            }
        }
        catch (EvaluateException e) {
            LOG.info("Could not load proxy class", (Throwable)e);
        }
        return DEFAULT_PROXY;
    }

    @Nullable
    private static ClassType ensureClassLoaded(@NotNull EvaluationContextImpl context, @NotNull VirtualMachineProxy vm) throws EvaluateException {
        List classes = vm.classesByName("com.intellij.memory.agent.proxy.IdeaNativeAgentProxy");
        if (classes.isEmpty()) {
            ClassType classType = AgentLoader.loadUtilityClass(context);
            if (classType == null) {
                LOG.error("Could not load proxy class");
            }
            return classType;
        }
        LOG.assertTrue(classes.size() == 1, (Object)("Too many utility classes loaded: " + classes.size()));
        return (ClassType)classes.get(0);
    }

    @Nullable
    private static ClassType loadUtilityClass(@NotNull EvaluationContextImpl context) throws EvaluateException {
        DebugProcessImpl debugProcess = context.getDebugProcess();
        byte[] bytes = AgentLoader.readUtilityClass();
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(context, debugProcess);
        ClassLoadingUtils.defineClass("com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", bytes, context, debugProcess, classLoader);
        return (ClassType)debugProcess.findClass(context, "com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", classLoader);
    }

    @NotNull
    private static byte[] readUtilityClass() {
        return new ProxyExtractor().extractProxy();
    }

    private static class MyDisabledMemoryAgent
    implements MemoryAgent {
        private MyDisabledMemoryAgent() {
        }

        @Override
        public boolean isLoaded() {
            return false;
        }

        @Override
        public boolean canEvaluateObjectSize() {
            return false;
        }

        @Override
        public long evaluateObjectSize(@NotNull ObjectReference reference) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canEvaluateObjectsSizes() {
            return false;
        }

        @Override
        public long[] evaluateObjectsSizes(@NotNull List<ObjectReference> references) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canFindGcRoots() {
            return false;
        }

        @Override
        @NotNull
        public ReferringObjectsInfo findGcRoots(@NotNull ObjectReference reference, int limit) {
            throw new UnsupportedOperationException();
        }
    }
}

