/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.parsers.BooleanParser;
import com.intellij.debugger.memory.agent.parsers.GcRootsPathsParser;
import com.intellij.debugger.memory.agent.parsers.LongArrayParser;
import com.intellij.debugger.memory.agent.parsers.LongValueParser;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MemoryAgentImpl
implements MemoryAgent {
    public static final String PROXY_CLASS_NAME = "com.intellij.memory.agent.proxy.IdeaNativeAgentProxy";
    private static final Logger LOG = Logger.getInstance(MemoryAgentImpl.class);
    private static final String SIZE_OF_SINGLE_OBJECT_METHOD_NAME = "size";
    private static final String SIZE_OF_OBJECTS_METHOD_NAME = "estimateRetainedSize";
    private static final String GARBAGE_COLLECTOR_ROOTS_METHOD_NAME = "gcRoots";
    private final DebugProcessImpl myDebugProcess;
    private final ClassType myProxyClassType;
    private volatile boolean myIsLoaded;
    private volatile boolean myCanFindGcRoots;
    private volatile boolean myCanEstimateObjectSize;
    private volatile boolean myCanEstimateObjectsSizes;

    public MemoryAgentImpl(@NotNull DebugProcessImpl debugProcess, @NotNull ClassType reference) {
        this.myDebugProcess = debugProcess;
        this.myProxyClassType = reference;
    }

    public void initializeCapabilities() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myIsLoaded = this.checkCapability("isLoaded");
        this.myCanFindGcRoots = this.checkCapability("canFindGcRoots");
        this.myCanEstimateObjectSize = this.checkCapability("canEstimateObjectSize");
        this.myCanEstimateObjectsSizes = this.checkCapability("canEstimateObjectsSizes");
    }

    @Override
    public boolean canEvaluateObjectSize() {
        return this.myCanEstimateObjectSize;
    }

    @Override
    public long evaluateObjectSize(@NotNull ObjectReference reference) throws EvaluateException {
        if (!this.canEvaluateObjectSize()) {
            throw new UnsupportedOperationException();
        }
        Value result = this.callMethod(SIZE_OF_SINGLE_OBJECT_METHOD_NAME, Collections.singletonList(reference));
        return LongValueParser.INSTANCE.parse(result);
    }

    @Override
    public boolean canEvaluateObjectsSizes() {
        return this.myCanEstimateObjectsSizes;
    }

    @Override
    public long[] evaluateObjectsSizes(@NotNull List<ObjectReference> references) throws EvaluateException {
        if (!this.canEvaluateObjectsSizes()) {
            throw new UnsupportedOperationException();
        }
        Value result = this.callMethod(SIZE_OF_OBJECTS_METHOD_NAME, references, (args, context) -> {
            long start = System.currentTimeMillis();
            ArrayType longArray = (ArrayType)this.myDebugProcess.findClass(context, "java.lang.Object[]", context.getClassLoader());
            ArrayReference instancesArray = longArray.newInstance(references.size());
            instancesArray.setValues(references);
            LOG.info("Wrapping values with array took " + (System.currentTimeMillis() - start) + " ms");
            return Collections.singletonList(instancesArray);
        });
        return LongArrayParser.INSTANCE.parse(result).stream().mapToLong(Long::longValue).toArray();
    }

    @Override
    public boolean canFindGcRoots() {
        return this.myCanFindGcRoots;
    }

    @Override
    @NotNull
    public ReferringObjectsInfo findGcRoots(@NotNull ObjectReference reference, int limit) throws EvaluateException {
        if (!this.canFindGcRoots()) {
            throw new UnsupportedOperationException();
        }
        IntegerValue limitValue = this.myDebugProcess.getVirtualMachineProxy().mirrorOf(limit);
        Value value = this.callMethod(GARBAGE_COLLECTOR_ROOTS_METHOD_NAME, Arrays.asList(reference, limitValue));
        return GcRootsPathsParser.INSTANCE.parse(value);
    }

    @Override
    public boolean isLoaded() {
        return this.myIsLoaded;
    }

    private boolean checkCapability(String methodName) {
        try {
            Value value = this.callMethod(methodName, Collections.emptyList());
            return BooleanParser.INSTANCE.parse(value);
        }
        catch (EvaluateException e) {
            return false;
        }
    }

    @NotNull
    private Value callMethod(@NotNull String methodName, @NotNull List<? extends Value> args) throws EvaluateException {
        return this.callMethod(methodName, args, ArgumentsTransformer.IDENTITY);
    }

    @NotNull
    private Value callMethod(@NotNull String methodName, @NotNull List<? extends Value> args, @NotNull ArgumentsTransformer transformer) throws EvaluateException {
        List<? extends Value> transformedArgs;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long start = System.currentTimeMillis();
        List<Method> methods = this.myProxyClassType.methodsByName(methodName);
        if (methods.isEmpty()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Could not find method with such name: " + methodName));
        }
        if (methods.size() > 1) {
            throw EvaluateExceptionUtil.createEvaluateException((String)("Too many methods \"" + methodName + "\" found. Count: " + methods.size()));
        }
        Method method = methods.get(0);
        if (!method.isStatic()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)"Utility method should be static");
        }
        SuspendContextImpl suspendContext = this.myDebugProcess.getSuspendManager().getPausedContext();
        EvaluationContextImpl evaluationContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
        try {
            transformedArgs = transformer.transform(args, evaluationContext);
        }
        catch (Exception e) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        }
        Value result = this.myDebugProcess.invokeMethod((EvaluationContext)evaluationContext, this.myProxyClassType, method, transformedArgs);
        LOG.info("Memory agent's method \"" + methodName + "\" took " + (System.currentTimeMillis() - start) + " ms");
        return result;
    }

    @FunctionalInterface
    private static interface ArgumentsTransformer {
        public static final ArgumentsTransformer IDENTITY = (args, context) -> args;

        public List<? extends Value> transform(@NotNull List<? extends Value> var1, @NotNull EvaluationContextImpl var2) throws EvaluateException, ClassNotLoadedException, InvalidTypeException;
    }
}

