/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.ReferringObject;
import com.intellij.debugger.engine.ReferringObjectsProvider;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.sun.jdi.ObjectReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MemoryAgentReferringObjectsProvider
implements ReferringObjectsProvider {
    private final MemoryAgent myAgent;
    private final int myObjectsToRequestLimit;
    private final Map<ObjectReference, ReferringObjectsInfo> myCachedRequests = new HashMap<ObjectReference, ReferringObjectsInfo>();

    public MemoryAgentReferringObjectsProvider(@NotNull MemoryAgent agent, int limit) {
        this.myAgent = agent;
        this.myObjectsToRequestLimit = limit;
    }

    @Override
    @NotNull
    public List<ReferringObject> getReferringObjects(@NotNull ObjectReference value, long limit) throws EvaluateException {
        if (this.myCachedRequests.containsKey(value)) {
            return this.myCachedRequests.get(value).getReferringObjects(value, limit);
        }
        for (ReferringObjectsInfo provider2 : this.myCachedRequests.values()) {
            if (!provider2.hasReferringObjectsFor(value)) continue;
            return provider2.getReferringObjects(value, limit);
        }
        ReferringObjectsInfo roots = this.myAgent.findGcRoots(value, this.myObjectsToRequestLimit);
        this.myCachedRequests.put(value, roots);
        return roots.getReferringObjects(value, limit);
    }
}

