/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.extractor;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import kotlin.Metadata;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/intellij/debugger/memory/agent/extractor/AgentExtractor;", "", "()V", "extract", "Ljava/io/File;", "agentType", "Lcom/intellij/debugger/memory/agent/extractor/AgentExtractor$AgentLibraryType;", "directory", "AgentLibraryType", "intellij.java.debugger.memory.agent"})
public final class AgentExtractor {
    @NotNull
    public final File extract(@NotNull AgentLibraryType agentType, @NotNull File directory) {
        File file = FileUtil.createTempFile((File)directory, (String)(agentType.getPrefix() + "memory_agent"), (String)agentType.getSuffix(), (boolean)true);
        String agentFileName = agentType.getPrefix() + "memory_agent" + agentType.getSuffix();
        InputStream inputStream = AgentExtractor.class.getClassLoader().getResourceAsStream("bin/" + agentFileName);
        if (inputStream == null) {
            throw (Throwable)new FileNotFoundException(agentFileName);
        }
        FileUtils.copyToFile((InputStream)inputStream, (File)file);
        return file;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/debugger/memory/agent/extractor/AgentExtractor$AgentLibraryType;", "", "prefix", "", "suffix", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "getSuffix", "WINDOWS32", "WINDOWS64", "LINUX", "MACOS", "intellij.java.debugger.memory.agent"})
    public static final class AgentLibraryType
    extends Enum<AgentLibraryType> {
        public static final /* enum */ AgentLibraryType WINDOWS32;
        public static final /* enum */ AgentLibraryType WINDOWS64;
        public static final /* enum */ AgentLibraryType LINUX;
        public static final /* enum */ AgentLibraryType MACOS;
        private static final /* synthetic */ AgentLibraryType[] $VALUES;
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;

        static {
            AgentLibraryType[] agentLibraryTypeArray = new AgentLibraryType[4];
            AgentLibraryType[] agentLibraryTypeArray2 = agentLibraryTypeArray;
            agentLibraryTypeArray[0] = WINDOWS32 = new AgentLibraryType("", "32.dll");
            agentLibraryTypeArray[1] = WINDOWS64 = new AgentLibraryType("", ".dll");
            agentLibraryTypeArray[2] = LINUX = new AgentLibraryType("lib", ".so");
            agentLibraryTypeArray[3] = MACOS = new AgentLibraryType("lib", ".dylib");
            $VALUES = agentLibraryTypeArray;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        private AgentLibraryType(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public static AgentLibraryType[] values() {
            return (AgentLibraryType[])$VALUES.clone();
        }

        public static AgentLibraryType valueOf(String string) {
            return Enum.valueOf(AgentLibraryType.class, string);
        }
    }
}

