/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.filtering;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.memory.filtering.CheckingResult;
import com.intellij.debugger.memory.filtering.ConditionChecker;
import com.intellij.debugger.memory.filtering.ConditionCheckerImpl;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XExpression;
import org.jetbrains.annotations.NotNull;

public class FilteringTask
implements Runnable {
    private final ValuesList myValues;
    private final ConditionChecker myChecker;
    private final FilteringTaskCallback myCallback;
    private volatile boolean myIsCancelled = false;

    public FilteringTask(@NotNull String className, @NotNull DebugProcessImpl debugProcess, @NotNull XExpression expression, @NotNull ValuesList values, @NotNull FilteringTaskCallback callback) {
        this.myChecker = StringUtil.isEmptyOrSpaces((String)expression.getExpression()) ? ConditionChecker.ALL_MATCHED_CHECKER : new ConditionCheckerImpl(debugProcess, expression, className);
        this.myValues = values;
        this.myCallback = callback;
    }

    public void cancel() {
        this.myIsCancelled = true;
    }

    public boolean isCancelled() {
        return this.myIsCancelled;
    }

    @Override
    public void run() {
        int proceedCount;
        this.myCallback.started(this.myValues.size());
        for (proceedCount = 0; proceedCount < this.myValues.size() && !this.myIsCancelled; ++proceedCount) {
            JavaReferenceInfo info = this.myValues.get(proceedCount);
            CheckingResult result = this.myChecker.check(info.getObjectReference());
            FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
            switch (result.getResult()) {
                case MATCH: {
                    action = this.myCallback.matched(info);
                    break;
                }
                case NO_MATCH: {
                    action = this.myCallback.notMatched(info);
                    break;
                }
                case ERROR: {
                    action = this.myCallback.error(info, result.getFailureDescription());
                }
            }
            if (action == FilteringTaskCallback.Action.STOP) break;
        }
        FilteringResult reason = this.myIsCancelled ? FilteringResult.INTERRUPTED : (proceedCount == this.myValues.size() ? FilteringResult.ALL_CHECKED : FilteringResult.LIMIT_REACHED);
        this.myCallback.completed(reason);
    }

    public static interface ValuesList {
        public int size();

        public JavaReferenceInfo get(int var1);
    }
}

