/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.tracking.ConstructorInstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.ui.JavaTypeInfo;
import com.intellij.debugger.memory.utils.LowestPriorityCommand;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.event.InstancesTrackerListener;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.intellij.xdebugger.memory.ui.ClassesFilteredViewBase;
import com.intellij.xdebugger.memory.ui.ClassesTable;
import com.intellij.xdebugger.memory.ui.InstancesWindowBase;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesFilteredView
extends ClassesFilteredViewBase {
    private static final Logger LOG = Logger.getInstance(ClassesFilteredView.class);
    public static final DataKey<InstancesProvider> NEW_INSTANCES_PROVIDER_KEY = DataKey.create((String)"ClassesTable.NewInstances");
    private final InstancesTracker myInstancesTracker;
    private final AtomicBoolean myIsTrackersActivated = new AtomicBoolean(false);
    private final Map<ReferenceType, ConstructorInstancesTracker> myConstructorTrackedClasses = new ConcurrentHashMap<ReferenceType, ConstructorInstancesTracker>();
    private final XDebugSessionListener additionalSessionListener;

    public ClassesFilteredView(final @NotNull XDebugSession debugSession, final @NotNull DebugProcessImpl debugProcess, final @NotNull InstancesTracker tracker) {
        super(debugSession);
        final DebuggerManagerThreadImpl managerThread = debugProcess.getManagerThread();
        this.myInstancesTracker = tracker;
        final InstancesTrackerListener instancesTrackerListener = new InstancesTrackerListener(){

            public void classChanged(@NotNull String name2, final @NotNull TrackingType type) {
                ClassesTable table = ClassesFilteredView.this.getTable();
                TypeInfo typeInfo = table.getClassByName(name2);
                if (typeInfo == null) {
                    return;
                }
                final ReferenceType ref = ((JavaTypeInfo)typeInfo).getReferenceType();
                if (ref != null) {
                    final boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                    managerThread.schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            ClassesFilteredView.this.trackClass(debugSession, debugProcess, ref, type, activated);
                        }
                    });
                }
                table.repaint();
            }

            public void classRemoved(@NotNull String name2) {
                ClassesTable table = ClassesFilteredView.this.getTable();
                TypeInfo ref = table.getClassByName(name2);
                if (ref == null) {
                    return;
                }
                JavaTypeInfo javaTypeInfo = (JavaTypeInfo)ref;
                if (ClassesFilteredView.this.myConstructorTrackedClasses.containsKey(javaTypeInfo.getReferenceType())) {
                    ConstructorInstancesTracker removed = (ConstructorInstancesTracker)ClassesFilteredView.this.myConstructorTrackedClasses.remove(javaTypeInfo.getReferenceType());
                    Disposer.dispose((Disposable)removed);
                    table.getRowSorter().allRowsChanged();
                }
            }
        };
        debugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ClassesFilteredView.this.myInstancesTracker.removeTrackerListener(instancesTrackerListener);
            }
        });
        debugProcess.addDebugProcessListener(new DebugProcessListener(){

            public void processAttached(@NotNull DebugProcess process2) {
                debugProcess.removeDebugProcessListener(this);
                managerThread.invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        boolean activated = ClassesFilteredView.this.myIsTrackersActivated.get();
                        VirtualMachineProxyImpl proxy = debugProcess.getVirtualMachineProxy();
                        if (!proxy.canBeModified()) {
                            return;
                        }
                        tracker.getTrackedClasses().forEach((className, type) -> {
                            List<ReferenceType> classes = proxy.classesByName((String)className);
                            if (classes.isEmpty()) {
                                this.trackWhenPrepared(className, debugSession, debugProcess, type);
                            } else {
                                for (ReferenceType ref : classes) {
                                    ClassesFilteredView.this.trackClass(debugSession, debugProcess, ref, type, activated);
                                }
                            }
                        });
                        tracker.addTrackerListener(instancesTrackerListener);
                    }
                });
            }

            private void trackWhenPrepared(@NotNull String className, final @NotNull XDebugSession session, final @NotNull DebugProcessImpl process2, final @NotNull TrackingType type) {
                ClassPrepareRequestor request = new ClassPrepareRequestor(){

                    public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                        process2.getRequestsManager().deleteRequest((Requestor)this);
                        ClassesFilteredView.this.trackClass(session, process2, referenceType, type, ClassesFilteredView.this.myIsTrackersActivated.get());
                    }
                };
                ClassPrepareRequest classPrepareRequest = process2.getRequestsManager().createClassPrepareRequest(request, className);
                if (classPrepareRequest != null) {
                    classPrepareRequest.enable();
                } else {
                    LOG.warn("Cannot create a 'class prepare' request. Class " + className + " not tracked.");
                }
            }
        });
        this.additionalSessionListener = new XDebugSessionListener(){

            public void sessionResumed() {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::obsolete);
            }

            public void sessionStopped() {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(Disposer::dispose);
                ClassesFilteredView.this.myConstructorTrackedClasses.clear();
            }
        };
        ClassesTable table = this.getTable();
        table.addMouseMotionListener((MouseMotionListener)new MyMouseMotionListener());
        table.addMouseListener((MouseListener)new MyOpenNewInstancesListener());
        new MyDoubleClickListener().installOn((Component)table);
    }

    private void trackClass(@NotNull XDebugSession session, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType ref, @NotNull TrackingType type, boolean isTrackerEnabled) {
        LOG.assertTrue(DebuggerManager.getInstance((Project)this.myProject).isDebuggerManagerThread());
        if (!debugProcess.getVirtualMachineProxy().canBeModified()) {
            return;
        }
        if (type == TrackingType.CREATION) {
            ConstructorInstancesTracker old = this.myConstructorTrackedClasses.getOrDefault(ref, null);
            if (old != null) {
                Disposer.dispose((Disposable)old);
            }
            ConstructorInstancesTracker tracker = new ConstructorInstancesTracker(ref, session, this.myInstancesTracker);
            tracker.setBackgroundMode(!this.myIsActive);
            if (isTrackerEnabled) {
                tracker.enable();
            } else {
                tracker.disable();
            }
            this.myConstructorTrackedClasses.put(ref, tracker);
        }
    }

    protected void scheduleUpdateClassesCommand(XSuspendContext context) {
        SuspendContextImpl suspendContext = (SuspendContextImpl)context;
        suspendContext.getDebugProcess().getManagerThread().schedule(new MyUpdateClassesCommand(suspendContext));
    }

    @Nullable
    protected TrackerForNewInstances getStrategy(@NotNull TypeInfo ref) {
        JavaTypeInfo javaTypeInfo = (JavaTypeInfo)ref;
        return this.myConstructorTrackedClasses.getOrDefault(javaTypeInfo.getReferenceType(), null);
    }

    protected InstancesWindowBase getInstancesWindow(@NotNull TypeInfo ref, XDebugSession debugSession) {
        return new InstancesWindow(debugSession, limit -> ref.getInstances(limit), ref.name());
    }

    protected void doActivate() {
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(false));
        super.doActivate();
    }

    protected void doPause() {
        super.doPause();
        this.myConstructorTrackedClasses.values().forEach(x -> x.setBackgroundMode(true));
    }

    public void dispose() {
        this.myConstructorTrackedClasses.clear();
    }

    public Object getData(@NotNull String dataId) {
        TrackerForNewInstances strategy;
        TypeInfo selectedClass;
        if (NEW_INSTANCES_PROVIDER_KEY.is(dataId) && (selectedClass = this.getTable().getSelectedClass()) != null && (strategy = this.getStrategy(selectedClass)) != null && strategy.isReady()) {
            List<ObjectReference> newInstances = strategy.getNewInstances();
            return limit -> ContainerUtil.map((Collection)newInstances, JavaReferenceInfo::new);
        }
        return null;
    }

    @Nullable
    protected XDebugSessionListener getAdditionalSessionListener() {
        return this.additionalSessionListener;
    }

    public void setActive(final boolean active, @NotNull DebuggerManagerThreadImpl managerThread) {
        if (this.myIsActive == active) {
            return;
        }
        this.myIsActive = active;
        managerThread.schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                if (active) {
                    ClassesFilteredView.this.doActivate();
                } else {
                    ClassesFilteredView.this.doPause();
                }
            }
        });
    }

    private void commitAllTrackers() {
        this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::commitTracked);
    }

    private boolean isShowNewInstancesEvent(@NotNull MouseEvent e) {
        ClassesTable table = this.getTable();
        int col = table.columnAtPoint(e.getPoint());
        int row = table.rowAtPoint(e.getPoint());
        if (col == -1 || row == -1 || table.convertColumnIndexToModel(col) != 2) {
            return false;
        }
        int modelRow = table.convertRowIndexToModel(row);
        JavaTypeInfo ref = (JavaTypeInfo)table.getModel().getValueAt(modelRow, 0);
        ConstructorInstancesTracker tracker = this.myConstructorTrackedClasses.getOrDefault(ref.getReferenceType(), null);
        return tracker != null && tracker.isReady() && tracker.getCount() > 0;
    }

    private final class MyUpdateClassesCommand
    extends LowestPriorityCommand {
        MyUpdateClassesCommand(SuspendContextImpl suspendContext) {
            super(suspendContext);
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContext) {
            this.handleTrackers();
            VirtualMachineProxyImpl proxy = suspendContext.getDebugProcess().getVirtualMachineProxy();
            List<ReferenceType> classes = proxy.allClasses();
            ClassesTable table = ClassesFilteredView.this.getTable();
            if (!classes.isEmpty()) {
                VirtualMachine vm = classes.get(0).virtualMachine();
                if (vm.canGetInstanceInfo()) {
                    Map<TypeInfo, Long> counts = this.getInstancesCounts(classes, vm);
                    ApplicationManager.getApplication().invokeLater(() -> table.updateContent(counts));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> table.updateClassesOnly(JavaTypeInfo.wrap(classes)));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> table.setBusy(false));
            ClassesFilteredView.this.viewUpdated();
        }

        private void handleTrackers() {
            if (!ClassesFilteredView.this.myIsTrackersActivated.get()) {
                ClassesFilteredView.this.myConstructorTrackedClasses.values().forEach(ConstructorInstancesTracker::enable);
                ClassesFilteredView.this.myIsTrackersActivated.set(true);
            } else {
                ClassesFilteredView.this.commitAllTrackers();
            }
        }

        private Map<TypeInfo, Long> getInstancesCounts(@NotNull List<ReferenceType> classes, @NotNull VirtualMachine vm) {
            int batchSize = DebuggerUtils.isAndroidVM((VirtualMachine)vm) ? 500 : Integer.MAX_VALUE;
            int size = classes.size();
            LinkedHashMap<TypeInfo, Long> result = new LinkedHashMap<TypeInfo, Long>();
            int begin = 0;
            int end = Math.min(batchSize, size);
            while (begin != size) {
                List<ReferenceType> batch = classes.subList(begin, end);
                long start = System.nanoTime();
                long[] counts = vm.instanceCounts(batch);
                long delay = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                for (int i = 0; i < batch.size(); ++i) {
                    result.put(new JavaTypeInfo(batch.get(i)), counts[i]);
                }
                int waitTime = (int)Math.min(0.5 * (double)delay, MAX_DELAY_MILLIS);
                ClassesFilteredView.this.mySingleAlarm.setDelay(waitTime);
                LOG.debug(String.format("Instances query time = %d ms. Count of classes = %d", delay, batch.size()));
                begin = end;
                end = Math.min(end + batchSize, size);
            }
            return result;
        }
    }

    private class MyDoubleClickListener
    extends DoubleClickListener {
        private MyDoubleClickListener() {
        }

        protected boolean onDoubleClick(MouseEvent event) {
            if (!ClassesFilteredView.this.isShowNewInstancesEvent(event)) {
                ClassesFilteredView.this.handleClassSelection(ClassesFilteredView.this.getTable().getSelectedClass());
                return true;
            }
            return false;
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ClassesTable table = ClassesFilteredView.this.getTable();
            if (table.isInClickableMode()) {
                return;
            }
            if (ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                table.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                table.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class MyOpenNewInstancesListener
    extends MouseAdapter {
        private MyOpenNewInstancesListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 1 || e.getButton() != 1 || !ClassesFilteredView.this.isShowNewInstancesEvent(e)) {
                return;
            }
            TypeInfo selectedTypeInfo = ClassesFilteredView.this.getTable().getSelectedClass();
            ReferenceType ref = selectedTypeInfo != null ? ((JavaTypeInfo)selectedTypeInfo).getReferenceType() : null;
            TrackerForNewInstances strategy = ref == null ? null : ClassesFilteredView.this.getStrategy(selectedTypeInfo);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getCurrentSession();
            if (strategy != null && debugSession != null) {
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ClassesFilteredView.this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
                MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
                if (data != null) {
                    List<ObjectReference> newInstances = strategy.getNewInstances();
                    data.getTrackedStacks().pinStacks(ref);
                    InstancesWindow instancesWindow = new InstancesWindow(debugSession, limit -> ContainerUtil.map((Collection)newInstances, JavaReferenceInfo::new), ref.name());
                    Disposer.register((Disposable)instancesWindow.getDisposable(), () -> data.getTrackedStacks().unpinStacks(ref));
                    instancesWindow.show();
                } else {
                    LOG.warn("MemoryViewDebugProcessData not found in debug session user data");
                }
            }
        }
    }
}

