/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.memory.ui.ReferenceInfo;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.sun.jdi.ReferenceType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaTypeInfo
implements TypeInfo {
    private final ReferenceType referenceType;

    public static List<TypeInfo> wrap(List<? extends ReferenceType> types) {
        return ContainerUtil.map(types, JavaTypeInfo::new);
    }

    public JavaTypeInfo(@NotNull ReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    @NotNull
    public String name() {
        return this.getReferenceType().name();
    }

    @NotNull
    public List<ReferenceInfo> getInstances(int limit) {
        return ContainerUtil.map(this.getReferenceType().instances(limit), JavaReferenceInfo::new);
    }

    @NotNull
    public ReferenceType getReferenceType() {
        return this.referenceType;
    }

    public boolean canGetInstanceInfo() {
        return this.referenceType.virtualMachine().canGetInstanceInfo();
    }

    public int hashCode() {
        return this.referenceType.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JavaTypeInfo)) {
            return false;
        }
        return ((JavaTypeInfo)obj).referenceType.equals(this.referenceType);
    }
}

