/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.memory.ui.JavaReferenceInfo;
import com.intellij.debugger.memory.utils.InstanceValueDescriptor;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ObjectReference;
import org.jetbrains.annotations.NotNull;

public class SizedReferenceInfo
extends JavaReferenceInfo {
    private final long mySize;

    public SizedReferenceInfo(@NotNull ObjectReference objectReference, long size) {
        super(objectReference);
        this.mySize = size;
    }

    @Override
    public ValueDescriptorImpl createDescriptor(@NotNull Project project2) {
        return new SizedValueDescriptor(project2, this.getObjectReference());
    }

    public long size() {
        return this.mySize;
    }

    private class SizedValueDescriptor
    extends InstanceValueDescriptor {
        protected SizedValueDescriptor(@NotNull Project project2, ObjectReference value) {
            super(project2, value);
        }

        @Override
        public String calcValueName() {
            return " [" + SizedReferenceInfo.this.mySize + "] " + super.calcValueName();
        }
    }
}

