/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.icons.AllIcons;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorsValueGroup
extends XValueGroup {
    private final Map<String, List<XNamedValue>> myErrorMessage2ValueMap = new HashMap<String, List<XNamedValue>>();

    public ErrorsValueGroup() {
        super("Errors");
    }

    public void addErrorValue(@NotNull String message, @NotNull XNamedValue value) {
        if (!this.myErrorMessage2ValueMap.containsKey(message)) {
            this.myErrorMessage2ValueMap.put(message, new ArrayList());
        }
        List<XNamedValue> lst = this.myErrorMessage2ValueMap.get(message);
        lst.add(value);
    }

    public boolean isEmpty() {
        return this.myErrorMessage2ValueMap.isEmpty();
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.General.Error;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        XValueChildrenList lst = new XValueChildrenList();
        this.myErrorMessage2ValueMap.keySet().forEach(s -> lst.addTopGroup((XValueGroup)new MyErrorsValueGroup((String)s)));
        node.addChildren(lst, true);
    }

    private class MyErrorsValueGroup
    extends XValueGroup {
        public void computeChildren(@NotNull XCompositeNode node) {
            XValueChildrenList lst = new XValueChildrenList();
            String name2 = this.getName();
            ((List)ErrorsValueGroup.this.myErrorMessage2ValueMap.get(name2)).forEach(arg_0 -> ((XValueChildrenList)lst).add(arg_0));
            node.addChildren(lst, true);
        }

        MyErrorsValueGroup(String name2) {
            super(name2);
        }
    }
}

