/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.codeInsight.AnnotationsPanel;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.debugger.settings.DebuggerProjectSettings;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xmlb.XmlSerializer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance(CaptureConfigurable.class);
    private final Project myProject;
    private JCheckBox myDebuggerAgent;
    private JButton myConfigureAnnotationsButton;
    private JPanel myCapturePanel;
    private MyTableModel myTableModel;
    private JCheckBox myCaptureVariables;
    private JPanel myPanel;

    public CaptureConfigurable(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
    }

    @NotNull
    public String getId() {
        return this.getHelpTopic();
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.idesettings.debugger.capture";
    }

    @Nullable
    public JComponent createComponent() {
        this.myTableModel = new MyTableModel();
        final JBTable table = new JBTable((TableModel)this.myTableModel);
        table.setColumnSelectionAllowed(false);
        final JTextField stringCellEditor = new JTextField();
        stringCellEditor.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
        table.setDefaultEditor(String.class, (TableCellEditor)new DefaultCellEditor(stringCellEditor));
        table.setDefaultRenderer(String.class, (TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                Dimension editorSize = stringCellEditor.getPreferredSize();
                size.height = Math.max(size.height, editorSize.height);
                return size;
            }
        });
        TableColumnModel columnModel = table.getColumnModel();
        TableUtil.setupCheckboxColumn((TableColumn)columnModel.getColumn(0));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)table);
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                CaptureConfigurable.this.myTableModel.addRow();
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)table);
            }
        });
        decorator.setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsUp((JTable)table);
            }
        });
        decorator.setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.moveSelectedItemsDown((JTable)table);
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Duplicate", "Duplicate", PlatformIcons.COPY_ICON){

            public boolean isEnabled() {
                return table.getSelectedRowCount() == 1;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    try {
                        int idx = CaptureConfigurable.this.myTableModel.add(c.clone());
                        table.getSelectionModel().setSelectionInterval(idx, idx);
                    }
                    catch (CloneNotSupportedException ex) {
                        LOG.error((Throwable)ex);
                    }
                });
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Enable Selected", "Enable Selected", PlatformIcons.SELECT_ALL_ICON){

            public boolean isEnabled() {
                return table.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    c.myEnabled = true;
                });
                table.repaint();
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Disable Selected", "Disable Selected", PlatformIcons.UNSELECT_ALL_ICON){

            public boolean isEnabled() {
                return table.getSelectedRowCount() > 0;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    c.myEnabled = false;
                });
                table.repaint();
            }
        });
        new DumbAwareAction("Toggle"){

            public void update(@NotNull AnActionEvent e) {
                e.getPresentation().setEnabled(table.getSelectedRowCount() == 1 && !table.isEditing());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    c.myEnabled = !c.myEnabled;
                });
                table.repaint();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(32, 0)), (JComponent)table);
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Import", "Import", AllIcons.Actions.Install){

            public void actionPerformed(@NotNull AnActionEvent e) {
                FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, true, false, true, true){

                    public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                        return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || "xml".equals(file.getExtension()) || file.getFileType() == ArchiveFileType.INSTANCE);
                    }

                    public boolean isFileSelectable(VirtualFile file) {
                        return file.getFileType() == StdFileTypes.XML;
                    }
                };
                descriptor2.setDescription("Please select a file to import.");
                descriptor2.setTitle("Import Capture Points");
                Object[] files = FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)e.getProject(), null);
                if (ArrayUtil.isEmpty((Object[])files)) {
                    return;
                }
                table.getSelectionModel().clearSelection();
                for (Object file : files) {
                    try {
                        for (Element element : JDOMUtil.load((InputStream)file.getInputStream()).getChildren()) {
                            int idx = CaptureConfigurable.this.myTableModel.addIfNeeded((CapturePoint)XmlSerializer.deserialize((Element)element, CapturePoint.class));
                            table.getSelectionModel().addSelectionInterval(idx, idx);
                        }
                    }
                    catch (Exception ex) {
                        String msg = ex.getLocalizedMessage();
                        Messages.showErrorDialog((Project)e.getProject(), (String)(msg != null && msg.length() > 0 ? msg : ex.toString()), (String)"Export Failed");
                    }
                }
            }
        });
        decorator.addExtraAction((AnActionButton)new DumbAwareActionButton("Export", "Export", AllIcons.ToolbarDecorator.Export){

            public void actionPerformed(@NotNull AnActionEvent e) {
                VirtualFileWrapper wrapper = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Export Selected Capture Points to File...", "", new String[]{"xml"}), e.getProject()).save(null, null);
                if (wrapper == null) {
                    return;
                }
                Element rootElement = new Element("capture-points");
                CaptureConfigurable.this.selectedCapturePoints(table).forEach(c -> {
                    try {
                        CapturePoint clone = c.clone();
                        clone.myEnabled = false;
                        rootElement.addContent(XmlSerializer.serialize((Object)clone));
                    }
                    catch (CloneNotSupportedException ex) {
                        LOG.error((Throwable)ex);
                    }
                });
                try {
                    JDOMUtil.write((Element)rootElement, (File)wrapper.getFile());
                }
                catch (Exception ex) {
                    String msg = ex.getLocalizedMessage();
                    Messages.showErrorDialog((Project)e.getProject(), (String)(msg != null && msg.length() > 0 ? msg : ex.toString()), (String)"Export Failed");
                }
            }

            public boolean isEnabled() {
                return table.getSelectedRowCount() > 0;
            }
        });
        this.myConfigureAnnotationsButton.addActionListener(e -> new AsyncAnnotationsDialog(this.myProject).show());
        this.myCapturePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Breakpoints based", (boolean)false));
        this.myCapturePanel.add((Component)decorator.createPanel(), "Center");
        return this.myPanel;
    }

    private StreamEx<CapturePoint> selectedCapturePoints(JBTable table) {
        return IntStreamEx.of((int[])table.getSelectedRows()).map(arg_0 -> table.convertRowIndexToModel(arg_0)).mapToObj(this.myTableModel::get);
    }

    public boolean isModified() {
        return DebuggerSettings.getInstance().CAPTURE_VARIABLES != this.myCaptureVariables.isSelected() || DebuggerSettings.getInstance().INSTRUMENTING_AGENT != this.myDebuggerAgent.isSelected() || !DebuggerSettings.getInstance().getCapturePoints().equals(this.myTableModel.myCapturePoints);
    }

    public void apply() throws ConfigurationException {
        DebuggerSettings.getInstance().setCapturePoints(this.myTableModel.myCapturePoints);
        DebuggerSettings.getInstance().CAPTURE_VARIABLES = this.myCaptureVariables.isSelected();
        DebuggerSettings.getInstance().INSTRUMENTING_AGENT = this.myDebuggerAgent.isSelected();
    }

    public void reset() {
        this.myCaptureVariables.setSelected(DebuggerSettings.getInstance().CAPTURE_VARIABLES);
        this.myDebuggerAgent.setSelected(DebuggerSettings.getInstance().INSTRUMENTING_AGENT);
        this.myTableModel.myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();
        this.myTableModel.scanPoints();
        this.myTableModel.fireTableDataChanged();
    }

    @Nls
    public String getDisplayName() {
        return DebuggerBundle.message((String)"async.stacktraces.configurable.display.name", (Object[])new Object[0]);
    }

    static void processCaptureAnnotations(BiConsumer<Boolean, PsiModifierListOwner> consumer) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        DebuggerProjectSettings debuggerProjectSettings = DebuggerProjectSettings.getInstance(project2);
        CaptureConfigurable.scanPointsInt(project2, debuggerProjectSettings, true, consumer);
        CaptureConfigurable.scanPointsInt(project2, debuggerProjectSettings, false, consumer);
    }

    private static void scanPointsInt(Project project2, DebuggerProjectSettings debuggerProjectSettings, boolean capture, BiConsumer<Boolean, PsiModifierListOwner> consumer) {
        try {
            GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project2);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            for (String annotationName : CaptureConfigurable.getAsyncAnnotations(debuggerProjectSettings, capture)) {
                PsiClass annotationClass = psiFacade.findClass(annotationName, allScope);
                if (annotationClass == null) continue;
                AnnotatedElementsSearch.searchElements((PsiClass)annotationClass, (SearchScope)allScope, (Class[])new Class[]{PsiMethod.class, PsiParameter.class}).forEach(e -> consumer.accept(capture, (PsiModifierListOwner)e));
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException allScope) {
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2);
        }
    }

    static String getAnnotationName(boolean capture) {
        return (capture ? Async.Schedule.class : Async.Execute.class).getName().replace("$", ".");
    }

    private static List<String> getAsyncAnnotations(DebuggerProjectSettings debuggerProjectSettings, boolean capture) {
        return StreamEx.of((Object[])(capture ? debuggerProjectSettings.myAsyncScheduleAnnotations : debuggerProjectSettings.myAsyncExecuteAnnotations)).prepend((Object)CaptureConfigurable.getAnnotationName(capture)).toList();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JButton jButton;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myDebuggerAgent = jBCheckBox;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.capture.configurable.debugger.agent"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConfigureAnnotationsButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.capture.configurable.annotations.configure"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCapturePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JBCheckBox jBCheckBox2 = new JBCheckBox();
        this.myCaptureVariables = jBCheckBox2;
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.capture.configurable.capture.variables"));
        jPanel.add((Component)jBCheckBox2, "South");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class AsyncAnnotationsDialog
    extends DialogWrapper {
        private final AnnotationsPanel myAsyncSchedulePanel;
        private final AnnotationsPanel myAsyncExecutePanel;
        private final DebuggerProjectSettings mySettings;

        private AsyncAnnotationsDialog(Project project2) {
            super(project2, true);
            this.mySettings = DebuggerProjectSettings.getInstance(CaptureConfigurable.this.myProject);
            this.myAsyncSchedulePanel = new AnnotationsPanel(project2, "Async Schedule", "", CaptureConfigurable.getAsyncAnnotations(this.mySettings, true), new String[]{CaptureConfigurable.getAnnotationName(true)}, Collections.emptySet(), false, false);
            this.myAsyncExecutePanel = new AnnotationsPanel(project2, "Async Execute", "", CaptureConfigurable.getAsyncAnnotations(this.mySettings, false), new String[]{CaptureConfigurable.getAnnotationName(false)}, Collections.emptySet(), false, false);
            this.init();
            this.setTitle("Async Annotations Configuration");
        }

        protected JComponent createCenterPanel() {
            Splitter splitter = new Splitter(true);
            splitter.setFirstComponent(this.myAsyncSchedulePanel.getComponent());
            splitter.setSecondComponent(this.myAsyncExecutePanel.getComponent());
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setPreferredSize((Dimension)JBUI.size((int)300, (int)400));
            return splitter;
        }

        protected void doOKAction() {
            this.mySettings.myAsyncScheduleAnnotations = (String[])((StreamEx)StreamEx.of((Object[])this.myAsyncSchedulePanel.getAnnotations()).filter(e -> !e.equals(CaptureConfigurable.getAnnotationName(true)))).toArray((Object[])ArrayUtil.EMPTY_STRING_ARRAY);
            this.mySettings.myAsyncExecuteAnnotations = (String[])((StreamEx)StreamEx.of((Object[])this.myAsyncExecutePanel.getAnnotations()).filter(e -> !e.equals(CaptureConfigurable.getAnnotationName(false)))).toArray((Object[])ArrayUtil.EMPTY_STRING_ARRAY);
            super.doOKAction();
        }

        @Nullable
        protected String getHelpId() {
            return "reference.idesettings.debugger.customAsyncAnnotations";
        }
    }

    private static class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        public static final int ENABLED_COLUMN = 0;
        public static final int CLASS_COLUMN = 1;
        public static final int METHOD_COLUMN = 2;
        public static final int PARAM_COLUMN = 3;
        public static final int INSERT_CLASS_COLUMN = 4;
        public static final int INSERT_METHOD_COLUMN = 5;
        public static final int INSERT_KEY_EXPR = 6;
        static final String[] COLUMN_NAMES = new String[]{"", "Capture class name", "Capture method name", "Capture key expression", "Insert class name", "Insert method name", "Insert key expression"};
        List<CapturePoint> myCapturePoints = DebuggerSettings.getInstance().cloneCapturePoints();

        private MyTableModel() {
            this.scanPoints();
        }

        private void scanPoints() {
            if (Registry.is((String)"debugger.capture.points.annotations")) {
                ArrayList capturePointsFromAnnotations = new ArrayList();
                CaptureConfigurable.processCaptureAnnotations((capture, e) -> {
                    if (e instanceof PsiMethod) {
                        MyTableModel.addCapturePointIfNeeded(e, (PsiMethod)e, "this", capture, capturePointsFromAnnotations);
                    } else if (e instanceof PsiParameter) {
                        PsiParameter psiParameter = (PsiParameter)e;
                        PsiMethod psiMethod = (PsiMethod)psiParameter.getDeclarationScope();
                        MyTableModel.addCapturePointIfNeeded((PsiModifierListOwner)psiParameter, psiMethod, "param_" + psiMethod.getParameterList().getParameterIndex(psiParameter), capture, capturePointsFromAnnotations);
                    }
                });
                capturePointsFromAnnotations.forEach(this::addIfNeeded);
            }
        }

        private static void addCapturePointIfNeeded(PsiModifierListOwner psiElement, PsiMethod psiMethod, String defaultExpression, boolean capture, List<CapturePoint> capturePointsFromAnnotations) {
            PsiAnnotation annotation;
            CapturePoint capturePoint = new CapturePoint();
            capturePoint.myEnabled = false;
            if (capture) {
                capturePoint.myClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            } else {
                capturePoint.myInsertClassName = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass());
                capturePoint.myInsertMethodName = JVMNameUtil.getJVMMethodName(psiMethod);
            }
            PsiModifierList modifierList = psiElement.getModifierList();
            if (modifierList != null && (annotation = modifierList.findAnnotation(CaptureConfigurable.getAnnotationName(capture))) != null) {
                String group;
                String keyExpression;
                PsiAnnotationMemberValue keyExpressionValue = annotation.findAttributeValue("keyExpression");
                String string = keyExpression = keyExpressionValue != null ? StringUtil.unquoteString((String)keyExpressionValue.getText()) : null;
                if (StringUtil.isEmpty((String)keyExpression)) {
                    keyExpression = defaultExpression;
                }
                if (capture) {
                    capturePoint.myCaptureKeyExpression = keyExpression;
                } else {
                    capturePoint.myInsertKeyExpression = keyExpression;
                }
                PsiAnnotationMemberValue groupValue = annotation.findAttributeValue("group");
                String string2 = group = groupValue != null ? StringUtil.unquoteString((String)groupValue.getText()) : null;
                if (!StringUtil.isEmpty((String)group)) {
                    for (CapturePoint capturePointsFromAnnotation : capturePointsFromAnnotations) {
                        if (!StringUtil.startsWith((CharSequence)group, (CharSequence)capturePointsFromAnnotation.myClassName) || !StringUtil.endsWith((CharSequence)group, (CharSequence)capturePointsFromAnnotation.myMethodName)) continue;
                        capturePointsFromAnnotation.myInsertClassName = capturePoint.myInsertClassName;
                        capturePointsFromAnnotation.myInsertMethodName = capturePoint.myInsertMethodName;
                        capturePointsFromAnnotation.myInsertKeyExpression = capturePoint.myInsertKeyExpression;
                        return;
                    }
                }
            }
            capturePointsFromAnnotations.add(capturePoint);
        }

        @Override
        public String getColumnName(int column) {
            return COLUMN_NAMES[column];
        }

        @Override
        public int getRowCount() {
            return this.myCapturePoints.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            CapturePoint point = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    return point.myEnabled;
                }
                case 1: {
                    return point.myClassName;
                }
                case 2: {
                    return point.myMethodName;
                }
                case 3: {
                    return point.myCaptureKeyExpression;
                }
                case 4: {
                    return point.myInsertClassName;
                }
                case 5: {
                    return point.myInsertMethodName;
                }
                case 6: {
                    return point.myInsertKeyExpression;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            CapturePoint point = this.myCapturePoints.get(row);
            switch (col) {
                case 0: {
                    point.myEnabled = (Boolean)value;
                    break;
                }
                case 1: {
                    point.myClassName = (String)value;
                    break;
                }
                case 2: {
                    point.myMethodName = (String)value;
                    break;
                }
                case 3: {
                    point.myCaptureKeyExpression = (String)value;
                    break;
                }
                case 4: {
                    point.myInsertClassName = (String)value;
                    break;
                }
                case 5: {
                    point.myInsertMethodName = (String)value;
                    break;
                }
                case 6: {
                    point.myInsertKeyExpression = (String)value;
                }
            }
            this.fireTableCellUpdated(row, col);
        }

        public Class getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : String.class;
        }

        CapturePoint get(int idx) {
            return this.myCapturePoints.get(idx);
        }

        int add(CapturePoint p) {
            this.myCapturePoints.add(p);
            int lastRow = this.getRowCount() - 1;
            this.fireTableRowsInserted(lastRow, lastRow);
            return lastRow;
        }

        int addIfNeeded(CapturePoint p) {
            CapturePoint clone = p;
            try {
                clone = p.clone();
                clone.myEnabled = !clone.myEnabled;
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Throwable)e);
            }
            int idx = this.myCapturePoints.indexOf(p);
            if (idx < 0) {
                idx = this.myCapturePoints.indexOf(clone);
            }
            if (idx < 0) {
                idx = this.add(p);
            }
            return idx;
        }

        public void addRow() {
            this.add(new CapturePoint());
        }

        public void removeRow(int row) {
            this.myCapturePoints.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }
}

