/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class CaptureSettingsProvider {
    private static final Logger LOG = Logger.getInstance(CaptureSettingsProvider.class);
    private static final KeyProvider THIS_KEY = new StringKeyProvider("this");
    private static final String ANY = "*";

    @NotNull
    public static Properties getPointsProperties() {
        Properties res = new Properties();
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            int idx = 0;
            for (AgentPoint point : CaptureSettingsProvider.getAnnotationPoints()) {
                res.setProperty((point.isCapture() ? "capture" : "insert") + idx++, point.myClassName + " " + point.myMethodName + " " + point.myMethodDesc + " " + point.myKey.asString());
            }
        }
        return res;
    }

    private static List<AgentPoint> getAnnotationPoints() {
        return (List)ReadAction.compute(() -> {
            ArrayList annotationPoints = new ArrayList();
            CaptureConfigurable.processCaptureAnnotations((capture, e) -> {
                PsiAnnotationMemberValue keyExpressionValue;
                PsiAnnotation annotation;
                KeyProvider keyProvider;
                PsiMethod method;
                if (e instanceof PsiMethod) {
                    method = (PsiMethod)e;
                    keyProvider = THIS_KEY;
                } else if (e instanceof PsiParameter) {
                    PsiParameter psiParameter = (PsiParameter)e;
                    method = (PsiMethod)psiParameter.getDeclarationScope();
                    keyProvider = CaptureSettingsProvider.param(method.getParameterList().getParameterIndex(psiParameter));
                } else {
                    return;
                }
                String classVMName = JVMNameUtil.getClassVMName(method.getContainingClass());
                if (classVMName == null) {
                    LOG.warn("Unable to find VM class name for annotated method: " + method.getName());
                    return;
                }
                String className = classVMName.replaceAll("\\.", "/");
                String methodName = JVMNameUtil.getJVMMethodName(method);
                String methodDesc = ANY;
                try {
                    methodDesc = JVMNameUtil.getJVMSignature(method).getName(null);
                }
                catch (EvaluateException ex) {
                    LOG.error((Throwable)ex);
                }
                PsiModifierList modifierList = e.getModifierList();
                if (modifierList != null && (annotation = modifierList.findAnnotation(CaptureConfigurable.getAnnotationName(capture))) != null && (keyExpressionValue = annotation.findAttributeValue("keyExpression")) != null && !"\"\"".equals(keyExpressionValue.getText())) {
                    keyProvider = new FieldKeyProvider(className, StringUtil.unquoteString((String)keyExpressionValue.getText()));
                }
                AgentPoint point = capture != false ? new AgentCapturePoint(className, methodName, methodDesc, keyProvider) : new AgentInsertPoint(className, methodName, methodDesc, keyProvider);
                annotationPoints.add(point);
            });
            return annotationPoints;
        });
    }

    private static KeyProvider param(int idx) {
        return new StringKeyProvider(Integer.toString(idx));
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String myClassName;
        private final String myFieldName;

        FieldKeyProvider(String className, String fieldName) {
            this.myClassName = className;
            this.myFieldName = fieldName;
        }

        @Override
        public String asString() {
            return this.myClassName + " " + this.myFieldName;
        }
    }

    private static class StringKeyProvider
    implements KeyProvider {
        private final String myValue;

        StringKeyProvider(String value) {
            this.myValue = value;
        }

        @Override
        public String asString() {
            return this.myValue;
        }
    }

    private static interface KeyProvider {
        public String asString();
    }

    private static class AgentInsertPoint
    extends AgentPoint {
        AgentInsertPoint(String className, String methodName, String methodDesc, KeyProvider key) {
            super(className, methodName, methodDesc, key);
        }

        @Override
        public boolean isCapture() {
            return false;
        }
    }

    private static class AgentCapturePoint
    extends AgentPoint {
        AgentCapturePoint(String className, String methodName, String methodDesc, KeyProvider key) {
            super(className, methodName, methodDesc, key);
        }

        @Override
        public boolean isCapture() {
            return true;
        }
    }

    private static abstract class AgentPoint {
        public final String myClassName;
        public final String myMethodName;
        public final String myMethodDesc;
        public final KeyProvider myKey;
        private static final String SEPARATOR = " ";

        AgentPoint(String className, String methodName, String methodDesc, KeyProvider key) {
            assert (!className.contains(".")) : "Classname should not contain . here";
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myMethodDesc = methodDesc;
            this.myKey = key;
        }

        public abstract boolean isCapture();

        public String toString() {
            return this.myClassName + "." + this.myMethodName + SEPARATOR + this.myKey.asString();
        }
    }
}

