/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebugUIEnvironment;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.DefaultDebugUIEnvironment;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerPanelsManager {
    private final Project myProject;

    public DebuggerPanelsManager(final Project project2) {
        this.myProject = project2;
        project2.getMessageBus().connect().subscribe(RunContentManager.TOPIC, (Object)new RunContentWithExecutorListener(){

            public void contentSelected(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
                if (executor == DefaultDebugExecutor.getDebugExecutorInstance()) {
                    DebuggerSession session;
                    DebuggerSession debuggerSession = session = descriptor2 == null ? null : DebuggerPanelsManager.getSession(project2, descriptor2);
                    if (session != null) {
                        DebuggerPanelsManager.this.getContextManager().setState(session.getContextManager().getContext(), session.getState(), DebuggerSession.Event.CONTEXT, null);
                    } else {
                        DebuggerPanelsManager.this.getContextManager().setState(DebuggerContextImpl.EMPTY_CONTEXT, DebuggerSession.State.DISPOSED, DebuggerSession.Event.CONTEXT, null);
                    }
                }
            }

            public void contentRemoved(@Nullable RunContentDescriptor descriptor2, @NotNull Executor executor) {
            }
        });
    }

    private DebuggerStateManager getContextManager() {
        return DebuggerManagerEx.getInstanceEx(this.myProject).getContextManager();
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(@NotNull ExecutionEnvironment environment, RunProfileState state, RemoteConnection remoteConnection, boolean pollConnection) throws ExecutionException {
        return this.attachVirtualMachine(new DefaultDebugUIEnvironment(environment, state, remoteConnection, pollConnection));
    }

    @Nullable
    public RunContentDescriptor attachVirtualMachine(DebugUIEnvironment environment) throws ExecutionException {
        DebugEnvironment modelEnvironment = environment.getEnvironment();
        final DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(this.myProject).attachVirtualMachine(modelEnvironment);
        if (debuggerSession == null) {
            return null;
        }
        XDebugSession debugSession = XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(modelEnvironment.getSessionName(), environment.getReuseContent(), new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                return JavaDebugProcess.create(session, debuggerSession);
            }
        });
        return debugSession.getRunContentDescriptor();
    }

    public static DebuggerPanelsManager getInstance(Project project2) {
        return (DebuggerPanelsManager)project2.getComponent(DebuggerPanelsManager.class);
    }

    private static DebuggerSession getSession(Project project2, RunContentDescriptor descriptor2) {
        for (JavaDebugProcess process2 : XDebuggerManager.getInstance((Project)project2).getDebugProcesses(JavaDebugProcess.class)) {
            if (!Comparing.equal((Object)process2.getProcessHandler(), (Object)descriptor2.getProcessHandler())) continue;
            return process2.getDebuggerSession();
        }
        return null;
    }
}

