/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.XBreakpointPackageGroup;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XBreakpointGroupingByPackageRule<B>
extends XBreakpointGroupingRule<B, XBreakpointPackageGroup> {
    protected XBreakpointGroupingByPackageRule() {
        super("XBreakpointGroupingByPackageRule", DebuggerBundle.message((String)"rule.name.group.by.package", (Object[])new Object[0]));
    }

    public int getPriority() {
        return 800;
    }

    public XBreakpointPackageGroup getGroup(@NotNull B breakpoint, @NotNull Collection<XBreakpointPackageGroup> groups) {
        Breakpoint javaBreakpoint;
        String packageName = null;
        if (breakpoint instanceof XBreakpoint && (javaBreakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)breakpoint)) != null) {
            packageName = javaBreakpoint.getPackageName();
        }
        if (packageName == null) {
            return null;
        }
        for (XBreakpointPackageGroup group : groups) {
            if (!StringUtil.equals((CharSequence)group.getPackageName(), (CharSequence)packageName)) continue;
            return group;
        }
        return new XBreakpointPackageGroup(packageName);
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Actions.GroupByPackage;
    }
}

