/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public abstract class AddFieldBreakpointDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myFieldChooser;
    private TextFieldWithBrowseButton myClassChooser;

    public AddFieldBreakpointDialog(Project project2) {
        super(project2, true);
        this.myProject = project2;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(DebuggerBundle.message((String)"add.field.breakpoint.dialog.title", (Object[])objectArray));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myClassChooser.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                AddFieldBreakpointDialog.this.updateUI();
            }
        });
        this.myClassChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiDirectory containingDirectory;
                PsiFile containingFile;
                PsiClass currentClass = AddFieldBreakpointDialog.this.getSelectedClass();
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)AddFieldBreakpointDialog.this.myProject).createAllProjectScopeChooser(DebuggerBundle.message((String)"add.field.breakpoint.dialog.classchooser.title", (Object[])new Object[0]));
                if (currentClass != null && (containingFile = currentClass.getContainingFile()) != null && (containingDirectory = containingFile.getContainingDirectory()) != null) {
                    chooser.selectDirectory(containingDirectory);
                }
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelected();
                if (selectedClass != null) {
                    AddFieldBreakpointDialog.this.myClassChooser.setText(selectedClass.getQualifiedName());
                }
            }
        });
        this.myFieldChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiClass selectedClass = AddFieldBreakpointDialog.this.getSelectedClass();
                if (selectedClass != null) {
                    Object[] fields = selectedClass.getFields();
                    MemberChooser chooser = new MemberChooser((ClassMember[])ContainerUtil.map2Array((Object[])fields, PsiFieldMember.class, PsiFieldMember::new), false, false, AddFieldBreakpointDialog.this.myProject);
                    chooser.setTitle(DebuggerBundle.message((String)"add.field.breakpoint.dialog.field.chooser.title", (Object[])new Object[]{fields.length}));
                    chooser.setCopyJavadocVisible(false);
                    TransactionGuard.getInstance().submitTransactionAndWait(() -> chooser.show());
                    List selectedElements = chooser.getSelectedElements();
                    if (selectedElements != null && selectedElements.size() == 1) {
                        PsiField field = (PsiField)((PsiFieldMember)selectedElements.get(0)).getElement();
                        AddFieldBreakpointDialog.this.myFieldChooser.setText(field.getName());
                    }
                }
            }
        });
        this.myFieldChooser.setEnabled(false);
        return this.myPanel;
    }

    private void updateUI() {
        PsiClass selectedClass = this.getSelectedClass();
        this.myFieldChooser.setEnabled(selectedClass != null);
    }

    private PsiClass getSelectedClass() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        String classQName = this.myClassChooser.getText();
        if (StringUtil.isEmpty((String)classQName)) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(classQName, GlobalSearchScope.allScope((Project)this.myProject));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassChooser.getTextField();
    }

    public String getClassName() {
        return this.myClassChooser.getText();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.BreakpointsConfigurationDialogFactory.BreakpointsConfigurationDialog.AddFieldBreakpointDialog";
    }

    public String getFieldName() {
        return this.myFieldChooser.getText();
    }

    protected abstract boolean validateData();

    protected void doOKAction() {
        if (this.validateData()) {
            super.doOKAction();
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, 6, false, false));
        this.myClassChooser = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myFieldChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, new GridConstraints(5, 0, 1, 1, 2, 1, 3, 3, new Dimension(-1, 1), null, new Dimension(-1, 1)));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createRaisedBevelBorder(), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.add.field.breakpoint.dialog.field.name"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/DebuggerBundle").getString("label.add.field.breakpoint.dialog.fq.name"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

