/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.settings.TraceSettings;
import com.intellij.debugger.ui.breakpoints.EditClassFiltersDialog;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class CallTracingPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XLineBreakpoint<JavaLineBreakpointProperties>> {
    private final Project myProject;
    private JBCheckBox myStartTracing;
    private JBCheckBox myEndTracing;

    public CallTracingPropertiesPanel(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public JComponent getComponent() {
        this.myStartTracing = new JBCheckBox("Start");
        this.myEndTracing = new JBCheckBox("Stop");
        JButton filters = new JButton("Filters...");
        JPanel _panel = new JPanel(new FlowLayout(0, 6, 0));
        _panel.add((Component)this.myStartTracing);
        _panel.add((Component)this.myEndTracing);
        _panel.add(filters);
        _panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Tracing", (boolean)true));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JBCheckBox toUncheck = null;
                if (CallTracingPropertiesPanel.this.myStartTracing.isSelected() && CallTracingPropertiesPanel.this.myEndTracing.isSelected()) {
                    Object source = e.getSource();
                    if (CallTracingPropertiesPanel.this.myStartTracing.equals(source)) {
                        toUncheck = CallTracingPropertiesPanel.this.myEndTracing;
                    } else if (CallTracingPropertiesPanel.this.myEndTracing.equals(source)) {
                        toUncheck = CallTracingPropertiesPanel.this.myStartTracing;
                    }
                    if (toUncheck != null) {
                        toUncheck.setSelected(false);
                    }
                }
            }
        };
        this.myStartTracing.addActionListener(listener);
        this.myEndTracing.addActionListener(listener);
        filters.addActionListener(e -> {
            EditClassFiltersDialog dialog = new EditClassFiltersDialog(this.myProject);
            TraceSettings traceSettings = TraceSettings.getInstance();
            dialog.setFilters(traceSettings.getClassFilters(), traceSettings.getClassExclusionFilters());
            dialog.setTitle("Tracing Class Filters");
            dialog.show();
            if (dialog.getExitCode() == 0) {
                traceSettings.setClassFilters(dialog.getFilters());
                traceSettings.setClassExclusionFilters(dialog.getExclusionFilters());
            }
        });
        return _panel;
    }

    public void loadFrom(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        this.myStartTracing.setSelected(((JavaLineBreakpointProperties)breakpoint.getProperties()).isTRACING_START());
        this.myEndTracing.setSelected(((JavaLineBreakpointProperties)breakpoint.getProperties()).isTRACING_END());
    }

    public void saveTo(@NotNull XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        boolean changed = ((JavaLineBreakpointProperties)breakpoint.getProperties()).setTRACING_START(this.myStartTracing.isSelected());
        boolean bl = changed = ((JavaLineBreakpointProperties)breakpoint.getProperties()).setTRACING_END(this.myEndTracing.isSelected()) || changed;
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }
}

