/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.DialogUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class ExceptionBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XBreakpoint<JavaExceptionBreakpointProperties>> {
    private JCheckBox myNotifyCaughtCheckBox;
    private JCheckBox myNotifyUncaughtCheckBox;

    @NotNull
    public JComponent getComponent() {
        this.myNotifyCaughtCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.exception.breakpoint.properties.panel.caught.exception", (Object[])new Object[0]));
        this.myNotifyUncaughtCheckBox = new JCheckBox(DebuggerBundle.message((String)"label.exception.breakpoint.properties.panel.uncaught.exception", (Object[])new Object[0]));
        DialogUtil.registerMnemonic((AbstractButton)this.myNotifyCaughtCheckBox);
        DialogUtil.registerMnemonic((AbstractButton)this.myNotifyUncaughtCheckBox);
        Box notificationsBox = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myNotifyCaughtCheckBox, "North");
        notificationsBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myNotifyUncaughtCheckBox, "North");
        notificationsBox.add(_panel);
        _panel = new JPanel(new BorderLayout());
        JPanel _panel0 = new JPanel(new BorderLayout());
        _panel0.add((Component)notificationsBox, "Center");
        _panel0.add(Box.createHorizontalStrut(3), "West");
        _panel0.add(Box.createHorizontalStrut(3), "East");
        _panel.add((Component)_panel0, "North");
        _panel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DebuggerBundle.message((String)"label.exception.breakpoint.properties.panel.group.notifications", (Object[])new Object[0]), (boolean)true));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ExceptionBreakpointPropertiesPanel.this.myNotifyCaughtCheckBox.isSelected() && !ExceptionBreakpointPropertiesPanel.this.myNotifyUncaughtCheckBox.isSelected()) {
                    Object source = e.getSource();
                    JCheckBox toCheck = null;
                    if (ExceptionBreakpointPropertiesPanel.this.myNotifyCaughtCheckBox.equals(source)) {
                        toCheck = ExceptionBreakpointPropertiesPanel.this.myNotifyUncaughtCheckBox;
                    } else if (ExceptionBreakpointPropertiesPanel.this.myNotifyUncaughtCheckBox.equals(source)) {
                        toCheck = ExceptionBreakpointPropertiesPanel.this.myNotifyCaughtCheckBox;
                    }
                    if (toCheck != null) {
                        toCheck.setSelected(true);
                    }
                }
            }
        };
        this.myNotifyCaughtCheckBox.addActionListener(listener);
        this.myNotifyUncaughtCheckBox.addActionListener(listener);
        return _panel;
    }

    public void loadFrom(@NotNull XBreakpoint<JavaExceptionBreakpointProperties> breakpoint) {
        this.myNotifyCaughtCheckBox.setSelected(((JavaExceptionBreakpointProperties)breakpoint.getProperties()).NOTIFY_CAUGHT);
        this.myNotifyUncaughtCheckBox.setSelected(((JavaExceptionBreakpointProperties)breakpoint.getProperties()).NOTIFY_UNCAUGHT);
    }

    public void saveTo(@NotNull XBreakpoint<JavaExceptionBreakpointProperties> breakpoint) {
        boolean changed = ((JavaExceptionBreakpointProperties)breakpoint.getProperties()).NOTIFY_CAUGHT != this.myNotifyCaughtCheckBox.isSelected();
        ((JavaExceptionBreakpointProperties)breakpoint.getProperties()).NOTIFY_CAUGHT = this.myNotifyCaughtCheckBox.isSelected();
        changed = ((JavaExceptionBreakpointProperties)breakpoint.getProperties()).NOTIFY_UNCAUGHT != this.myNotifyUncaughtCheckBox.isSelected() || changed;
        ((JavaExceptionBreakpointProperties)breakpoint.getProperties()).NOTIFY_UNCAUGHT = this.myNotifyUncaughtCheckBox.isSelected();
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }
}

