/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FilteredRequestorImpl
implements JDOMExternalizable,
FilteredRequestor {
    public String SUSPEND_POLICY = "SuspendAll";
    public boolean SUSPEND = true;
    public boolean COUNT_FILTER_ENABLED = false;
    public int COUNT_FILTER = 0;
    public boolean CONDITION_ENABLED = false;
    private TextWithImports myCondition;
    public boolean CLASS_FILTERS_ENABLED = false;
    private ClassFilter[] myClassFilters = ClassFilter.EMPTY_ARRAY;
    private ClassFilter[] myClassExclusionFilters = ClassFilter.EMPTY_ARRAY;
    public boolean INSTANCE_FILTERS_ENABLED = false;
    private InstanceFilter[] myInstanceFilters = InstanceFilter.EMPTY_ARRAY;
    @NonNls
    private static final String FILTER_OPTION_NAME = "filter";
    @NonNls
    private static final String EXCLUSION_FILTER_OPTION_NAME = "exclusion_filter";
    @NonNls
    private static final String INSTANCE_ID_OPTION_NAME = "instance_id";
    @NonNls
    private static final String CONDITION_OPTION_NAME = "CONDITION";
    protected final Project myProject;

    public FilteredRequestorImpl(@NotNull Project project2) {
        this.myProject = project2;
        this.myCondition = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return this.myInstanceFilters;
    }

    public void setInstanceFilters(InstanceFilter[] instanceFilters) {
        this.myInstanceFilters = instanceFilters != null ? instanceFilters : InstanceFilter.EMPTY_ARRAY;
    }

    @Override
    public String getSuspendPolicy() {
        return this.SUSPEND ? this.SUSPEND_POLICY : "SuspendNone";
    }

    @Override
    public final ClassFilter[] getClassFilters() {
        return this.myClassFilters;
    }

    public final void setClassFilters(ClassFilter[] classFilters) {
        this.myClassFilters = classFilters != null ? classFilters : ClassFilter.EMPTY_ARRAY;
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return this.myClassExclusionFilters;
    }

    public void setClassExclusionFilters(ClassFilter[] classExclusionFilters) {
        this.myClassExclusionFilters = classExclusionFilters != null ? classExclusionFilters : ClassFilter.EMPTY_ARRAY;
    }

    public void readTo(Element parentNode, Breakpoint breakpoint) throws InvalidDataException {
        this.readExternal(parentNode);
        if (this.SUSPEND) {
            breakpoint.setSuspendPolicy(this.SUSPEND_POLICY);
        } else {
            breakpoint.setSuspendPolicy("SuspendNone");
        }
        breakpoint.setCountFilterEnabled(this.COUNT_FILTER_ENABLED);
        breakpoint.setCountFilter(this.COUNT_FILTER);
        breakpoint.setCondition(this.myCondition);
        ((XBreakpointBase)breakpoint.myXBreakpoint).setConditionEnabled(this.CONDITION_ENABLED);
        if (this.myCondition != null && !this.myCondition.isEmpty()) {
            XDebuggerHistoryManager.getInstance((Project)this.myProject).addRecentExpression("breakpointCondition", TextWithImportsImpl.toXExpression(this.myCondition));
        }
        breakpoint.setClassFiltersEnabled(this.CLASS_FILTERS_ENABLED);
        breakpoint.setClassFilters(this.getClassFilters());
        breakpoint.setClassExclusionFilters(this.getClassExclusionFilters());
        breakpoint.setInstanceFiltersEnabled(this.INSTANCE_FILTERS_ENABLED);
        breakpoint.setInstanceFilters(this.getInstanceFilters());
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        String condition;
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)parentNode);
        if ("SuspendNone".equals(this.SUSPEND_POLICY)) {
            this.SUSPEND = false;
            this.SUSPEND_POLICY = "SuspendAll";
        }
        if ((condition = JDOMExternalizerUtil.readField((Element)parentNode, (String)CONDITION_OPTION_NAME)) != null) {
            this.setCondition(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, condition));
        }
        this.myClassFilters = DebuggerUtilsEx.readFilters(parentNode.getChildren(FILTER_OPTION_NAME));
        this.myClassExclusionFilters = DebuggerUtilsEx.readFilters(parentNode.getChildren(EXCLUSION_FILTER_OPTION_NAME));
        ClassFilter[] instanceFilters = DebuggerUtilsEx.readFilters(parentNode.getChildren(INSTANCE_ID_OPTION_NAME));
        ArrayList<InstanceFilter> iFilters = new ArrayList<InstanceFilter>(instanceFilters.length);
        for (ClassFilter instanceFilter : instanceFilters) {
            try {
                iFilters.add(InstanceFilter.create(instanceFilter));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.myInstanceFilters = iFilters.isEmpty() ? InstanceFilter.EMPTY_ARRAY : iFilters.toArray(InstanceFilter.EMPTY_ARRAY);
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)parentNode);
        JDOMExternalizerUtil.writeField((Element)parentNode, (String)CONDITION_OPTION_NAME, (String)this.getCondition().toExternalForm());
        DebuggerUtilsEx.writeFilters(parentNode, FILTER_OPTION_NAME, this.myClassFilters);
        DebuggerUtilsEx.writeFilters(parentNode, EXCLUSION_FILTER_OPTION_NAME, this.myClassExclusionFilters);
        DebuggerUtilsEx.writeFilters(parentNode, INSTANCE_ID_OPTION_NAME, InstanceFilter.createClassFilters(this.myInstanceFilters));
    }

    public TextWithImports getCondition() {
        return this.myCondition;
    }

    public void setCondition(TextWithImports condition) {
        this.myCondition = condition;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean isCountFilterEnabled() {
        return this.COUNT_FILTER_ENABLED;
    }

    @Override
    public int getCountFilter() {
        return this.COUNT_FILTER;
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return this.CLASS_FILTERS_ENABLED;
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return this.INSTANCE_FILTERS_ENABLED;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
        return false;
    }
}

