/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaBreakpointTypeBase<T extends JavaBreakpointProperties>
extends XBreakpointType<XBreakpoint<T>, T>
implements JavaBreakpointType<T> {
    protected JavaBreakpointTypeBase(@NonNls @NotNull String id, @Nls @NotNull String title) {
        super(id, title, true);
    }

    public final boolean isAddBreakpointButtonVisible() {
        return true;
    }

    @NotNull
    public final XBreakpointCustomPropertiesPanel<XBreakpoint<T>> createCustomRightPropertiesPanel(@NotNull Project project2) {
        return new JavaBreakpointFiltersPanel(project2);
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XBreakpoint<T> breakpoint, @NotNull Project project2) {
        return new JavaDebuggerEditorsProvider();
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<T> breakpoint) {
        PsiClass aClass;
        Breakpoint javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint != null && (aClass = javaBreakpoint.getPsiClass()) != null) {
            return (XSourcePosition)ReadAction.compute(() -> XDebuggerUtil.getInstance().createPositionByElement((PsiElement)aClass));
        }
        return null;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XBreakpoint<T> breakpoint, @Nullable XDebugSession currentSession) {
        return BreakpointIntentionAction.getIntentions(breakpoint, currentSession);
    }
}

