/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.ui.breakpoints.BreakpointIntentionAction;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PairFunction;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;
import org.jetbrains.java.debugger.breakpoints.JavaBreakpointFiltersPanel;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public abstract class JavaLineBreakpointTypeBase<P extends JavaBreakpointProperties>
extends XLineBreakpointType<P>
implements JavaBreakpointType<P> {
    public JavaLineBreakpointTypeBase(@NonNls @NotNull String id, @Nls @NotNull String title) {
        super(id, title);
    }

    public final boolean isSuspendThreadSupported() {
        return true;
    }

    @NotNull
    public final XBreakpointCustomPropertiesPanel<XLineBreakpoint<P>> createCustomRightPropertiesPanel(@NotNull Project project2) {
        return new JavaBreakpointFiltersPanel(project2);
    }

    @NotNull
    public final XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<P> breakpoint, @NotNull Project project2) {
        return new JavaDebuggerEditorsProvider();
    }

    public String getDisplayText(XLineBreakpoint<P> breakpoint) {
        BreakpointWithHighlighter javaBreakpoint = (BreakpointWithHighlighter)BreakpointManager.getJavaBreakpoint(breakpoint);
        if (javaBreakpoint != null) {
            return javaBreakpoint.getDescription();
        }
        return super.getDisplayText(breakpoint);
    }

    protected static boolean canPutAtElement(@NotNull VirtualFile file, int line, @NotNull Project project2, @NotNull PairFunction<? super PsiElement, ? super Document, Boolean> processor2) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        if (psiFile == null || psiFile.getViewProvider().getFileType() == StdFileTypes.XHTML) {
            return false;
        }
        if (!StdFileTypes.CLASS.equals(psiFile.getFileType()) && !DebuggerUtils.isBreakpointAware((PsiFile)psiFile)) {
            return false;
        }
        if ("kt".equals(psiFile.getFileType().getDefaultExtension())) {
            return false;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(file);
        if (document2 != null) {
            Ref res = Ref.create((Object)false);
            XDebuggerUtil.getInstance().iterateLine(project2, document2, line, element -> {
                if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiComment.class, PsiImportStatementBase.class, PsiPackageStatement.class}) != null) {
                    return true;
                }
                PsiElement parent = element;
                while (element != null) {
                    if (element instanceof PsiModifierList) {
                        element = element.getParent();
                        continue;
                    }
                    int offset = element.getTextOffset();
                    if (!DocumentUtil.isValidOffset((int)offset, (Document)document2) || document2.getLineNumber(offset) != line) break;
                    parent = element;
                    element = element.getParent();
                }
                if (((Boolean)processor2.fun((Object)parent, (Object)document2)).booleanValue()) {
                    res.set((Object)true);
                    return false;
                }
                return true;
            });
            return (Boolean)res.get();
        }
        return false;
    }

    public List<? extends AnAction> getAdditionalPopupMenuActions(@NotNull XLineBreakpoint<P> breakpoint, @Nullable XDebugSession currentSession) {
        return BreakpointIntentionAction.getIntentions(breakpoint, currentSession);
    }
}

