/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.util.PairFunction;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

public class JavaMethodBreakpointType
extends JavaLineBreakpointTypeBase<JavaMethodBreakpointProperties> {
    public JavaMethodBreakpointType() {
        super("java-method", DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]));
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_method_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_method_breakpoint;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        return AllIcons.Debugger.Db_no_suspend_method_breakpoint;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        return AllIcons.Debugger.Db_muted_method_breakpoint;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        return AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return AllIcons.Debugger.Db_dep_method_breakpoint;
    }

    protected String getHelpID() {
        return "debugging.methodBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"method.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public String getShortText(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        return JavaMethodBreakpointType.getText(breakpoint);
    }

    static String getText(XBreakpoint<JavaMethodBreakpointProperties> breakpoint) {
        boolean classNameExists;
        StringBuilder buffer = new StringBuilder();
        String className = ((JavaMethodBreakpointProperties)breakpoint.getProperties()).myClassPattern;
        boolean bl = classNameExists = className != null && className.length() > 0;
        if (classNameExists) {
            buffer.append(className);
        }
        if (((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName != null) {
            if (classNameExists) {
                buffer.append(".");
            }
            buffer.append(((JavaMethodBreakpointProperties)breakpoint.getProperties()).myMethodName);
        }
        return buffer.toString();
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel createCustomPropertiesPanel(@NotNull Project project2) {
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        return new JavaMethodBreakpointProperties();
    }

    @Nullable
    public JavaMethodBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        JavaMethodBreakpointProperties properties = new JavaMethodBreakpointProperties();
        if (Registry.is((String)"debugger.emulate.method.breakpoints")) {
            properties.EMULATED = true;
        }
        return properties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaMethodBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint) {
        return new MethodBreakpoint(project2, breakpoint);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project2) {
        return JavaMethodBreakpointType.canPutAtElement(file, line, project2, (PairFunction<? super PsiElement, ? super Document, Boolean>)((PairFunction)(element, document2) -> element instanceof PsiMethod));
    }
}

