/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunToCursorBreakpoint
extends SyntheticLineBreakpoint {
    private final boolean myRestoreBreakpoints;
    @NotNull
    protected final SourcePosition myCustomPosition;

    protected RunToCursorBreakpoint(@NotNull Project project2, @NotNull SourcePosition pos, boolean restoreBreakpoints) {
        super(project2);
        this.myCustomPosition = pos;
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    @Override
    @NotNull
    public SourcePosition getSourcePosition() {
        return this.myCustomPosition;
    }

    @Override
    public int getLineIndex() {
        return this.myCustomPosition.getLine();
    }

    @Override
    protected String getFileName() {
        return this.myCustomPosition.getFile().getName();
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public String getEventMessage(LocatableEvent event) {
        return DebuggerBundle.message((String)"status.stopped.at.cursor", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    protected JavaLineBreakpointType getXBreakpointType() {
        SourcePosition position = this.getSourcePosition();
        VirtualFile file = position.getFile().getVirtualFile();
        int line = position.getLine();
        for (XLineBreakpointType type : XDebuggerUtil.getInstance().getLineBreakpointTypes()) {
            if (!(type instanceof JavaLineBreakpointType) || !type.canPutAt(file, line, this.myProject)) continue;
            return (JavaLineBreakpointType)type;
        }
        return null;
    }

    @Nullable
    protected static RunToCursorBreakpoint create(@NotNull Project project2, @NotNull XSourcePosition position, boolean restoreBreakpoints) {
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(position.getFile());
        if (psiFile == null) {
            return null;
        }
        return new RunToCursorBreakpoint(project2, SourcePosition.createFromOffset((PsiFile)psiFile, (int)position.getOffset()), restoreBreakpoints);
    }
}

